/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.outreach.internal.events;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.plugins.outreach.internal.LogUtils;
import com.sonatype.nexus.plugins.outreach.internal.outreach.PageBundleMetadata;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.events.EventSubscriber;
import org.sonatype.nexus.proxy.events.NexusStoppingEvent;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class OutreachCleanupEventInspector
extends ComponentSupport
implements EventSubscriber {
    private final ApplicationConfiguration config;

    @Inject
    public OutreachCleanupEventInspector(ApplicationConfiguration config) {
        this.config = (ApplicationConfiguration)Preconditions.checkNotNull((Object)config);
    }

    @Subscribe
    public void inspect(NexusStoppingEvent evt) {
        File dir = new File(this.config.getTemporaryDirectory(), "outreach");
        File[] files = dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".metadata");
            }
        });
        if (files != null && files.length > 0) {
            for (File md : files) {
                try {
                    DateTime expires = this.createNewPageBundleMetadata(md).getExpires();
                    if (expires == null || !expires.isBeforeNow()) continue;
                    new File(md.getAbsolutePath().replace(".metadata", "")).delete();
                }
                catch (IOException e) {
                    new File(md.getAbsolutePath().replace(".metadata", "")).delete();
                    md.delete();
                    LogUtils.logThrowable(this.log, "While checking outreach bundle expiry could not parse metadata {}", new Object[]{md, e});
                }
            }
        }
    }

    @VisibleForTesting
    protected PageBundleMetadata createNewPageBundleMetadata(File md) throws IOException {
        return new PageBundleMetadata(md);
    }
}

