/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.outreach.internal.capabilities;

import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.Map;
import org.sonatype.nexus.plugins.capabilities.ValidationResult;
import org.sonatype.nexus.plugins.capabilities.Validator;
import org.sonatype.nexus.plugins.capabilities.support.validator.DefaultValidationResult;

public class URLValidator
implements Validator {
    private final String key;

    public URLValidator(String key) {
        this.key = (String)Preconditions.checkNotNull((Object)key);
    }

    public ValidationResult validate(Map<String, String> properties) {
        String value = properties.get(this.key);
        try {
            new URL(value);
            return ValidationResult.VALID;
        }
        catch (Exception e) {
            return new DefaultValidationResult().add(this.key, "\"" + value + "\" is not a valid URL (" + e.getMessage() + ")");
        }
    }

    public String explainValid() {
        return "URL is valid";
    }

    public String explainInvalid() {
        return "URL is invalid";
    }
}

