/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.outreach.internal.capabilities;

import com.google.common.collect.Lists;
import com.sonatype.nexus.plugins.outreach.internal.capabilities.URLValidator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.capability.support.CapabilityDescriptorSupport;
import org.sonatype.nexus.formfields.CheckboxFormField;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.StringTextFormField;
import org.sonatype.nexus.plugins.capabilities.CapabilityIdentity;
import org.sonatype.nexus.plugins.capabilities.CapabilityType;
import org.sonatype.nexus.plugins.capabilities.ValidationResult;
import org.sonatype.nexus.plugins.capabilities.Validator;
import org.sonatype.nexus.plugins.capabilities.internal.validator.ConjunctionValidator;

@Named(value="OutreachManagementCapability")
@Singleton
public class OutreachManagementCapabilityDescriptor
extends CapabilityDescriptorSupport {
    public static final String TYPE_ID = "OutreachManagementCapability";
    public static final CapabilityType TYPE = CapabilityType.capabilityType((String)"OutreachManagementCapability");
    public static final String DEFAULT_BASE_URL = "http://links.sonatype.com/products/nexus/outreach";
    public static final String BASE_URL = "baseUrl";
    public static final String CACHING_DISABLED = "alwaysRemote";
    public static final String OVERRIDE_URL = "overrideUrl";
    private final List<FormField> formFields = Lists.newArrayList((Object[])new FormField[]{new StringTextFormField("baseUrl", "Base URL", "URL to use for querying page bundles.", true), new CheckboxFormField("alwaysRemote", "Disable Caching", "Always check the remote server for updates", false), new StringTextFormField("overrideUrl", "Override URL", "Always retrieve the page bundle with this URL instead of using Nexus edition, version, user and language.<br/>Leave empty to disable override.", false)});

    @Inject
    public OutreachManagementCapabilityDescriptor() {
    }

    public CapabilityType type() {
        return TYPE;
    }

    public String name() {
        return "Outreach : Management";
    }

    public List<FormField> formFields() {
        return this.formFields;
    }

    public boolean isHidden() {
        return true;
    }

    public Validator validator() {
        return new ConjunctionValidator(new Validator[]{new URLValidator(BASE_URL), new URLValidator(OVERRIDE_URL){

            @Override
            public ValidationResult validate(Map<String, String> properties) {
                if (StringUtils.isEmpty((String)properties.get(OutreachManagementCapabilityDescriptor.OVERRIDE_URL))) {
                    return ValidationResult.VALID;
                }
                return super.validate(properties);
            }
        }});
    }

    public Validator validator(CapabilityIdentity id) {
        return this.validator();
    }
}

