/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.outreach.internal.capabilities;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.sonatype.nexus.plugins.outreach.OutreachPlugin;
import com.sonatype.nexus.plugins.outreach.internal.capabilities.OutreachManagementCapabilityDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.support.CapabilitySupport;
import org.sonatype.nexus.plugins.capabilities.CapabilityReference;
import org.sonatype.nexus.plugins.capabilities.CapabilityRegistry;
import org.sonatype.nexus.plugins.capabilities.Condition;
import org.sonatype.nexus.plugins.capabilities.support.CapabilityReferenceFilterBuilder;

@Named(value="OutreachManagementCapability")
@Singleton
public class OutreachManagementCapability
extends CapabilitySupport<Map> {
    private static final Lookup CACHING_DISABLED = new Lookup("alwaysRemote");
    private static final Lookup BASE_URL = new Lookup("baseUrl");
    private static final Lookup OVERRIDE_URL = new Lookup("overrideUrl");
    private final OutreachPlugin plugin;

    protected Map createConfig(Map<String, String> properties) throws Exception {
        return properties;
    }

    public static boolean isDisabled(CapabilityRegistry capabilities) {
        Collection<? extends CapabilityReference> references = OutreachManagementCapability.capabilityReferences(capabilities);
        return references.isEmpty() || !references.iterator().next().context().isActive();
    }

    public static boolean isCachingDisabled(CapabilityRegistry capabilities) {
        return Boolean.valueOf(OutreachManagementCapability.getValue(capabilities, CACHING_DISABLED));
    }

    public static String getBaseUrl(CapabilityRegistry capabilities) {
        String url = OutreachManagementCapability.getValue(capabilities, BASE_URL);
        if (url == null) {
            return "http://links.sonatype.com/products/nexus/outreach";
        }
        return url;
    }

    public static String getOverrideUrl(CapabilityRegistry capabilities) {
        return OutreachManagementCapability.getValue(capabilities, OVERRIDE_URL);
    }

    private static String getValue(CapabilityRegistry capabilities, Function<Map<String, String>, String> lookup) {
        Collection<? extends CapabilityReference> references = OutreachManagementCapability.capabilityReferences(capabilities);
        if (references.isEmpty()) {
            return null;
        }
        return (String)lookup.apply((Object)references.iterator().next().context().properties());
    }

    private static Collection<? extends CapabilityReference> capabilityReferences(CapabilityRegistry capabilities) {
        return capabilities.get((Predicate)CapabilityReferenceFilterBuilder.capabilities().withType(OutreachManagementCapabilityDescriptor.TYPE));
    }

    @Inject
    public OutreachManagementCapability(OutreachPlugin plugin) {
        this.plugin = (OutreachPlugin)((Object)Preconditions.checkNotNull((Object)((Object)plugin), (Object)"plugin info was null"));
    }

    public Condition activationCondition() {
        final File tmpDir = this.plugin.getTemporaryDirectory();
        return new Condition(){

            public boolean isSatisfied() {
                File test = new File(tmpDir, "outreach.test");
                if (!test.exists() || test.delete()) {
                    try {
                        test.createNewFile();
                        test.delete();
                        return true;
                    }
                    catch (IOException e) {
                        OutreachManagementCapability.this.log.warn("No write access for temp directory ({})", (Object)tmpDir);
                    }
                } else {
                    OutreachManagementCapability.this.log.warn("No write access for temp directory ({}), could not delete file '{}'", (Object)tmpDir, (Object)test.getName());
                }
                return false;
            }

            public Condition bind() {
                return this;
            }

            public Condition release() {
                return this;
            }

            public String explainSatisfied() {
                return "Outreach temporary Directory is created";
            }

            public String explainUnsatisfied() {
                return "Cannot write to Outreach temp directory (" + tmpDir + ")";
            }
        };
    }

    private static class Lookup
    implements Function<Map<String, String>, String> {
        private final String key;

        private Lookup(String key) {
            this.key = key;
        }

        public String apply(Map<String, String> input) {
            return input.get(this.key);
        }
    }
}

