/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.outreach.internal;

import java.util.Arrays;
import org.slf4j.Logger;

public class LogUtils {
    public static void logThrowable(Logger log, String format, Throwable t) {
        if (t instanceof RuntimeException) {
            log.warn(format, t);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(format, t);
            return;
        }
        if (t != null) {
            log.info(format + (format.contains("{}") ? "" : "\n{}"), (Object)t.toString());
        } else {
            log.info(format, t);
        }
    }

    public static void logThrowable(Logger log, String format, Object[] args) {
        if (args == null || args.length == 0) {
            log.info(format);
            return;
        }
        Object lastArg = args[args.length - 1];
        if (lastArg instanceof RuntimeException) {
            log.warn(format, args);
            return;
        }
        if (lastArg instanceof Throwable) {
            if (log.isDebugEnabled()) {
                log.debug(format, args);
                return;
            }
            Throwable t = (Throwable)lastArg;
            if (t != null) {
                Object[] newArgs = Arrays.copyOf(args, args.length);
                newArgs[newArgs.length - 1] = t.toString();
                log.info(format, newArgs);
                return;
            }
            log.info(format, args);
            return;
        }
        log.info(format, args);
    }
}

