/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.outreach;

import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.sisu.EagerSingleton;
import org.sonatype.nexus.configuration.application.ApplicationDirectories;
import org.sonatype.nexus.plugin.PluginIdentity;
import org.sonatype.nexus.util.file.DirSupport;

@Named
@EagerSingleton
public class OutreachPlugin
extends PluginIdentity {
    public static final String GROUP_ID = "com.sonatype.nexus.plugins";
    public static final String ARTIFACT_ID = "nexus-outreach-plugin";
    private static final String TMP_DIR_NAME = "outreach";
    private File tmpDir;

    @Inject
    public OutreachPlugin(ApplicationDirectories directories) throws Exception {
        super(GROUP_ID, ARTIFACT_ID);
        Preconditions.checkNotNull((Object)directories);
        this.tmpDir = new File(directories.getTemporaryDirectory(), TMP_DIR_NAME).getAbsoluteFile();
        DirSupport.mkdir((Path)this.tmpDir.toPath());
    }

    public File getTemporaryDirectory() {
        return this.tmpDir;
    }
}

