/*
 * Decompiled with CFR 0.152.
 */
package com.headius.invokebinder;

import com.headius.invokebinder.Binder;
import com.headius.invokebinder.Signature;
import com.headius.invokebinder.SmartHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SmartBinder {
    private final Signature start;
    private final List<Signature> signatures = new ArrayList<Signature>();
    private final Binder binder;

    private SmartBinder(Signature start, Binder binder) {
        this.start = start;
        this.signatures.add(start);
        this.binder = binder;
    }

    private SmartBinder(SmartBinder original, Signature next, Binder binder) {
        this.start = original.start;
        this.signatures.add(0, next);
        this.signatures.addAll(original.signatures);
        this.binder = binder;
    }

    public Signature signature() {
        return this.signatures.get(0);
    }

    public Binder binder() {
        return this.binder;
    }

    public static SmartBinder from(Signature inbound) {
        return new SmartBinder(inbound, Binder.from(inbound.type()));
    }

    public static SmartBinder from(MethodHandles.Lookup lookup, Signature inbound) {
        return new SmartBinder(inbound, Binder.from(lookup, inbound.type()));
    }

    public SmartBinder fold(String newName, MethodHandle function) {
        return new SmartBinder(this, this.signature().prependArg(newName, (Class)function.type().returnType()), this.binder.fold(function));
    }

    public SmartBinder fold(String newName, SmartHandle function) {
        if (Arrays.equals(this.signature().argNames(), function.signature().argNames())) {
            return this.fold(newName, function.handle());
        }
        return this.fold(newName, this.signature().changeReturn((Class)function.signature().type().returnType()).permuteWith(function).handle());
    }

    public SmartBinder foldVoid(MethodHandle function) {
        return new SmartBinder(this, this.signature(), this.binder.foldVoid(function));
    }

    public SmartBinder foldVoid(SmartHandle function) {
        if (Arrays.equals(this.signature().argNames(), function.signature().argNames())) {
            return this.foldVoid(function.handle());
        }
        return this.foldVoid(this.signature().asFold(Void.TYPE).permuteWith(function).handle());
    }

    public SmartBinder foldStatic(String newName, MethodHandles.Lookup lookup, Class target, String method) {
        Binder newBinder = this.binder.foldStatic(lookup, target, method);
        return new SmartBinder(this, this.signature().prependArg(newName, (Class)newBinder.type().parameterType(0)), this.binder);
    }

    public SmartBinder foldStatic(String newName, Class target, String method) {
        Binder newBinder = this.binder.foldStatic(target, method);
        return new SmartBinder(this, this.signature().prependArg(newName, (Class)newBinder.type().parameterType(0)), this.binder);
    }

    public SmartBinder foldVirtual(String newName, MethodHandles.Lookup lookup, String method) {
        Binder newBinder = this.binder.foldVirtual(lookup, method);
        return new SmartBinder(this, this.signature().prependArg(newName, (Class)newBinder.type().parameterType(0)), this.binder);
    }

    public SmartBinder foldVirtual(String newName, String method) {
        Binder newBinder = this.binder.foldVirtual(method);
        return new SmartBinder(this, this.signature().prependArg(newName, (Class)newBinder.type().parameterType(0)), this.binder);
    }

    public SmartBinder permute(Signature target) {
        return new SmartBinder(this, target, this.binder.permute(this.signature().to(target)));
    }

    public SmartBinder permute(String ... targetNames) {
        return this.permute(this.signature().permute(targetNames));
    }

    public SmartBinder exclude(String ... excludeNames) {
        return this.permute(this.signature().exclude(excludeNames));
    }

    public SmartBinder spread(String[] spreadNames, Class ... spreadTypes) {
        return new SmartBinder(this, this.signature().spread(spreadNames, spreadTypes), this.binder.spread(spreadTypes));
    }

    public SmartBinder spread(String baseName, int count) {
        return new SmartBinder(this, this.signature().spread(baseName, count), this.binder.spread(count));
    }

    public SmartBinder insert(int index, String name, Object value) {
        return new SmartBinder(this, this.signature().insertArg(index, name, value.getClass()), this.binder.insert(index, value));
    }

    public SmartBinder insert(int index, String name, boolean value) {
        return new SmartBinder(this, this.signature().insertArg(index, name, Boolean.TYPE), this.binder.insert(index, value));
    }

    public SmartBinder insert(int index, String name, byte value) {
        return new SmartBinder(this, this.signature().insertArg(index, name, Byte.TYPE), this.binder.insert(index, value));
    }

    public SmartBinder insert(int index, String name, short value) {
        return new SmartBinder(this, this.signature().insertArg(index, name, Short.TYPE), this.binder.insert(index, value));
    }

    public SmartBinder insert(int index, String name, char value) {
        return new SmartBinder(this, this.signature().insertArg(index, name, Character.TYPE), this.binder.insert(index, value));
    }

    public SmartBinder insert(int index, String name, int value) {
        return new SmartBinder(this, this.signature().insertArg(index, name, Integer.TYPE), this.binder.insert(index, value));
    }

    public SmartBinder insert(int index, String name, long value) {
        return new SmartBinder(this, this.signature().insertArg(index, name, Long.TYPE), this.binder.insert(index, value));
    }

    public SmartBinder insert(int index, String name, float value) {
        return new SmartBinder(this, this.signature().insertArg(index, name, Float.TYPE), this.binder.insert(index, value));
    }

    public SmartBinder insert(int index, String name, double value) {
        return new SmartBinder(this, this.signature().insertArg(index, name, Double.TYPE), this.binder.insert(index, value));
    }

    public SmartBinder insert(int index, String[] names, Class[] types, Object ... values) {
        return new SmartBinder(this, this.signature().insertArgs(index, names, types), this.binder.insert(index, types, values));
    }

    public SmartBinder append(String name, Object value) {
        return new SmartBinder(this, this.signature().appendArg(name, value.getClass()), this.binder.append(value));
    }

    public SmartBinder append(String name, boolean value) {
        return new SmartBinder(this, this.signature().appendArg(name, Boolean.TYPE), this.binder.append(value));
    }

    public SmartBinder append(String name, byte value) {
        return new SmartBinder(this, this.signature().appendArg(name, Byte.TYPE), this.binder.append(value));
    }

    public SmartBinder append(String name, short value) {
        return new SmartBinder(this, this.signature().appendArg(name, Short.TYPE), this.binder.append(value));
    }

    public SmartBinder append(String name, char value) {
        return new SmartBinder(this, this.signature().appendArg(name, Character.TYPE), this.binder.append(value));
    }

    public SmartBinder append(String name, int value) {
        return new SmartBinder(this, this.signature().appendArg(name, Integer.TYPE), this.binder.append(value));
    }

    public SmartBinder append(String name, long value) {
        return new SmartBinder(this, this.signature().appendArg(name, Long.TYPE), this.binder.append(value));
    }

    public SmartBinder append(String name, float value) {
        return new SmartBinder(this, this.signature().appendArg(name, Float.TYPE), this.binder.append(value));
    }

    public SmartBinder append(String name, double value) {
        return new SmartBinder(this, this.signature().appendArg(name, Double.TYPE), this.binder.append(value));
    }

    public SmartBinder append(String[] names, Class[] types, Object ... values) {
        return new SmartBinder(this, this.signature().appendArgs(names, types), this.binder.append(types, values));
    }

    public SmartBinder prepend(String name, Object value) {
        return new SmartBinder(this, this.signature().prependArg(name, value.getClass()), this.binder.prepend(value));
    }

    public SmartBinder prepend(String name, boolean value) {
        return new SmartBinder(this, this.signature().prependArg(name, Boolean.TYPE), this.binder.prepend(value));
    }

    public SmartBinder prepend(String name, byte value) {
        return new SmartBinder(this, this.signature().prependArg(name, Byte.TYPE), this.binder.prepend(value));
    }

    public SmartBinder prepend(String name, short value) {
        return new SmartBinder(this, this.signature().prependArg(name, Short.TYPE), this.binder.prepend(value));
    }

    public SmartBinder prepend(String name, char value) {
        return new SmartBinder(this, this.signature().prependArg(name, Character.TYPE), this.binder.prepend(value));
    }

    public SmartBinder prepend(String name, int value) {
        return new SmartBinder(this, this.signature().prependArg(name, Integer.TYPE), this.binder.prepend(value));
    }

    public SmartBinder prepend(String name, long value) {
        return new SmartBinder(this, this.signature().prependArg(name, Long.TYPE), this.binder.prepend(value));
    }

    public SmartBinder prepend(String name, float value) {
        return new SmartBinder(this, this.signature().prependArg(name, Float.TYPE), this.binder.prepend(value));
    }

    public SmartBinder prepend(String name, double value) {
        return new SmartBinder(this, this.signature().prependArg(name, Double.TYPE), this.binder.prepend(value));
    }

    public SmartBinder prepend(String[] names, Class[] types, Object ... values) {
        return new SmartBinder(this, this.signature().prependArgs(names, types), this.binder.prepend(types, values));
    }

    public SmartBinder cast(Signature target) {
        return new SmartBinder(target, this.binder.cast(target.type()));
    }

    public SmartBinder cast(Class returnType, Class ... argTypes) {
        return new SmartBinder(this, new Signature(returnType, argTypes, this.signature().argNames()), this.binder.cast(returnType, argTypes));
    }

    public SmartBinder castArg(String name, Class type) {
        Signature newSig = this.signature().replaceArg(name, name, type);
        return new SmartBinder(this, newSig, this.binder.cast(newSig.type()));
    }

    public SmartBinder castReturn(Class type) {
        return new SmartBinder(this, this.signature().changeReturn(type), this.binder.cast(type, this.binder.type().parameterArray()));
    }

    public SmartBinder filterReturn(MethodHandle filter) {
        return new SmartBinder(this, this.signature().changeReturn((Class)filter.type().returnType()), this.binder.filterReturn(filter));
    }

    public SmartBinder filterReturn(SmartHandle filter) {
        return new SmartBinder(this, this.signature().changeReturn((Class)filter.signature().type().returnType()), this.binder.filterReturn(filter.handle()));
    }

    public SmartHandle invokeVirtualQuiet(MethodHandles.Lookup lookup, String name) {
        return new SmartHandle(this.start, this.binder.invokeVirtualQuiet(lookup, name));
    }

    public SmartHandle invokeStaticQuiet(MethodHandles.Lookup lookup, Class target, String name) {
        return new SmartHandle(this.start, this.binder.invokeStaticQuiet(lookup, target, name));
    }

    public SmartHandle invoke(SmartHandle target) {
        return new SmartHandle(this.start, this.binder.invoke(target.handle()));
    }

    public SmartHandle invoke(MethodHandle target) {
        return new SmartHandle(this.start, this.binder.invoke(target));
    }

    public SmartBinder printSignature() {
        System.out.println(this.signature().toString());
        return this;
    }

    public SmartHandle arrayGet() {
        return new SmartHandle(this.start, this.binder.arrayGet());
    }

    public SmartHandle arraySet() {
        return new SmartHandle(this.start, this.binder.arraySet());
    }

    public SmartHandle invoker() {
        return new SmartHandle(this.start, this.binder.invoker());
    }
}

