/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.maven.bridge.support.settings;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.sisu.maven.bridge.Names;
import org.sonatype.sisu.maven.bridge.support.MavenSettings;
import org.sonatype.sisu.maven.bridge.support.MavenSettingsFactory;
import org.sonatype.sisu.maven.bridge.support.settings.DefaultMavenSettings;

@Named
public class DefaultMavenSettingsFactory
implements MavenSettingsFactory {
    private File globalSettings;
    private File userSettings;
    private ServiceLocator serviceLocator;
    private RepositorySystem repositorySystem;
    private final List<RemoteRepository> repositories;

    public DefaultMavenSettingsFactory(ServiceLocator serviceLocator) {
        this(serviceLocator, null);
    }

    public DefaultMavenSettingsFactory(ServiceLocator serviceLocator, List<RemoteRepository> repositories) {
        this.serviceLocator = serviceLocator;
        this.globalSettings = Names.DEFAULT_GLOBAL_SETTINGS_FILE;
        this.userSettings = Names.DEFAULT_USER_SETTINGS_FILE;
        this.repositories = repositories;
    }

    @Inject
    public DefaultMavenSettingsFactory(ServiceLocator serviceLocator, @Nullable @Named(value="${mavenbridge.globalSettings}") File globalSettings, @Nullable @Named(value="${mavenbridge.userSettings}") File userSettings, @Nullable @Named(value="${mavenbridge.repositories}") String repositories) {
        this(serviceLocator, DefaultMavenSettingsFactory.toRemoteRepositories(repositories));
        if (globalSettings != null && globalSettings.isFile()) {
            this.globalSettings = globalSettings;
        }
        if (userSettings != null && userSettings.isFile()) {
            this.userSettings = userSettings;
        }
    }

    @Override
    public MavenSettings create() {
        return this.create(this.globalSettings);
    }

    @Override
    public MavenSettings create(File globalSettings) {
        return this.create(globalSettings, this.userSettings);
    }

    @Override
    public MavenSettings create(File globalSettings, File userSettings) {
        return new DefaultMavenSettings(globalSettings, userSettings, this.getRepositorySystem(), this.repositories);
    }

    private RepositorySystem getRepositorySystem() {
        if (this.repositorySystem == null) {
            this.repositorySystem = (RepositorySystem)this.serviceLocator.getService(RepositorySystem.class);
        }
        return this.repositorySystem;
    }

    private static List<RemoteRepository> toRemoteRepositories(String repositories) {
        ArrayList remoteRepositories = Lists.newArrayList();
        if (repositories != null && repositories.length() > 0) {
            String[] segments;
            for (String segment : segments = repositories.split(",")) {
                String[] parts = segment.split("::");
                if (parts.length != 3) {
                    throw new IllegalArgumentException("Expected '<id>::<layout>::<url>' but got '" + segment + "'");
                }
                remoteRepositories.add(new RemoteRepository(parts[0], parts[1], parts[2]));
            }
        }
        return remoteRepositories;
    }
}

