/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.maven.bridge.support.settings;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.AuthenticationSelector;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.repository.MirrorSelector;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.ProxySelector;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.util.repository.DefaultAuthenticationSelector;
import org.sonatype.aether.util.repository.DefaultMirrorSelector;
import org.sonatype.aether.util.repository.DefaultProxySelector;
import org.sonatype.sisu.maven.bridge.internal.RepositorySystemSessionWrapper;
import org.sonatype.sisu.maven.bridge.support.MavenSettings;
import org.sonatype.sisu.maven.bridge.support.RemoteRepositoryBuilder;

public class DefaultMavenSettings
implements MavenSettings {
    private MirrorSelector mirrorSelector;
    private Collection<RemoteRepository> repositories;
    private AuthenticationSelector authenticationSelector;
    private ProxySelector proxySelector;
    private LocalRepositoryManager localRepositoryManager;
    private RepositorySystem repositorySystem;

    public DefaultMavenSettings(File globalSettings, File userSettings, RepositorySystem repositorySystem, List<RemoteRepository> repositories) {
        this.repositorySystem = repositorySystem;
        DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest();
        settingsRequest.setGlobalSettingsFile(globalSettings);
        settingsRequest.setUserSettingsFile(userSettings);
        settingsRequest.setSystemProperties(System.getProperties());
        try {
            DefaultSettingsBuilder settingsBuilder = new DefaultSettingsBuilderFactory().newInstance();
            Settings settings = settingsBuilder.build((SettingsBuildingRequest)settingsRequest).getEffectiveSettings();
            this.repositories = DefaultMavenSettings.getRepositories(settings, repositories);
            this.mirrorSelector = DefaultMavenSettings.createMirrorSelector(settings);
            this.authenticationSelector = this.createAuthenticationSelector(settings);
            this.proxySelector = this.createProxySelector(settings);
            this.localRepositoryManager = this.createLocalRepositoryManager(settings);
        }
        catch (SettingsBuildingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public ArtifactRequest inject(ArtifactRequest request) {
        for (RemoteRepository repository : this.repositories) {
            request.addRepository(repository);
        }
        return request;
    }

    @Override
    public CollectRequest inject(CollectRequest request) {
        for (RemoteRepository repository : this.repositories) {
            request.addRepository(repository);
        }
        return request;
    }

    @Override
    public RepositorySystemSession inject(final RepositorySystemSession session) {
        return new RepositorySystemSessionWrapper(session){

            @Override
            public MirrorSelector getMirrorSelector() {
                return new MirrorSelector(){

                    public RemoteRepository getMirror(RemoteRepository repository) {
                        RemoteRepository mirror;
                        if (DefaultMavenSettings.this.mirrorSelector != null && (mirror = DefaultMavenSettings.this.mirrorSelector.getMirror(repository)) != null) {
                            return mirror;
                        }
                        return session.getMirrorSelector().getMirror(repository);
                    }
                };
            }

            @Override
            public AuthenticationSelector getAuthenticationSelector() {
                return new AuthenticationSelector(){

                    public Authentication getAuthentication(RemoteRepository repository) {
                        Authentication auth;
                        if (DefaultMavenSettings.this.authenticationSelector != null && (auth = DefaultMavenSettings.this.authenticationSelector.getAuthentication(repository)) != null) {
                            return auth;
                        }
                        return session.getAuthenticationSelector().getAuthentication(repository);
                    }
                };
            }

            @Override
            public ProxySelector getProxySelector() {
                return new ProxySelector(){

                    public Proxy getProxy(RemoteRepository repository) {
                        Proxy proxy;
                        if (DefaultMavenSettings.this.proxySelector != null && (proxy = DefaultMavenSettings.this.proxySelector.getProxy(repository)) != null) {
                            return proxy;
                        }
                        return session.getProxySelector().getProxy(repository);
                    }
                };
            }

            @Override
            public LocalRepositoryManager getLocalRepositoryManager() {
                LocalRepositoryManager sessionLocalRepositoryManager = session.getLocalRepositoryManager();
                if (sessionLocalRepositoryManager == null) {
                    return DefaultMavenSettings.this.localRepositoryManager;
                }
                return sessionLocalRepositoryManager;
            }

            @Override
            public LocalRepository getLocalRepository() {
                LocalRepositoryManager manager = this.getLocalRepositoryManager();
                LocalRepository repository = null;
                if (manager != null && (repository = manager.getRepository()) == null && DefaultMavenSettings.this.localRepositoryManager != null) {
                    return DefaultMavenSettings.this.localRepositoryManager.getRepository();
                }
                return repository;
            }
        };
    }

    private static Collection<RemoteRepository> getRepositories(Settings settings, List<RemoteRepository> repositories) {
        HashMap remoteRepositories = Maps.newHashMap();
        List activeProfiles = settings.getActiveProfiles();
        for (Profile profile : settings.getProfiles()) {
            if (!activeProfiles.contains(profile.getId())) continue;
            for (Repository repository : profile.getRepositories()) {
                remoteRepositories.put(repository.getId(), RemoteRepositoryBuilder.remoteRepository(repository));
            }
        }
        if (repositories != null && !repositories.isEmpty()) {
            for (RemoteRepository repository : repositories) {
                remoteRepositories.put(repository.getId(), repository);
            }
        }
        if (!remoteRepositories.containsKey("central")) {
            RemoteRepository central = RemoteRepositoryBuilder.remoteRepository("central", "default", "http://repo.maven.apache.org/maven2");
            remoteRepositories.put("central", central);
        }
        return remoteRepositories.values();
    }

    private static MirrorSelector createMirrorSelector(Settings settings) {
        List mirrors = settings.getMirrors();
        if (mirrors != null && mirrors.size() > 0) {
            DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
            for (Mirror mirror : mirrors) {
                mirrorSelector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
            }
            return mirrorSelector;
        }
        return null;
    }

    private AuthenticationSelector createAuthenticationSelector(Settings settings) {
        List servers = settings.getServers();
        if (servers != null && servers.size() > 0) {
            DefaultAuthenticationSelector authenticationSelector = new DefaultAuthenticationSelector();
            for (Server server : servers) {
                authenticationSelector.add(server.getId(), new Authentication(server.getUsername(), server.getPassword(), server.getPrivateKey(), server.getPassphrase()));
            }
            return authenticationSelector;
        }
        return null;
    }

    private ProxySelector createProxySelector(Settings settings) {
        List proxies = settings.getProxies();
        if (proxies != null && proxies.size() > 0) {
            DefaultProxySelector ps = new DefaultProxySelector();
            for (org.apache.maven.settings.Proxy proxy : proxies) {
                if (!proxy.isActive()) continue;
                ps.add(new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), new Authentication(proxy.getUsername(), proxy.getPassword())), proxy.getNonProxyHosts());
            }
            return ps;
        }
        return null;
    }

    private LocalRepositoryManager createLocalRepositoryManager(Settings settings) {
        String localRepositoryPath = settings.getLocalRepository();
        if (localRepositoryPath == null) {
            return null;
        }
        return this.repositorySystem.newLocalRepositoryManager(new LocalRepository(localRepositoryPath));
    }
}

