/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.maven.bridge.support.session;

import java.io.File;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.AbstractRepositoryListener;
import org.sonatype.aether.RepositoryEvent;
import org.sonatype.aether.RepositoryListener;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.aether.transfer.AbstractTransferListener;
import org.sonatype.aether.transfer.TransferCancelledException;
import org.sonatype.aether.transfer.TransferEvent;
import org.sonatype.aether.transfer.TransferListener;

@Named
public class MavenBridgeRepositorySystemSession
extends MavenRepositorySystemSession
implements RepositorySystemSession {
    private Logger log;
    private final RepositorySystem repositorySystem;

    @Inject
    public MavenBridgeRepositorySystemSession(ServiceLocator serviceLocator) {
        this.repositorySystem = (RepositorySystem)serviceLocator.getService(RepositorySystem.class);
        this.setRepositoryListener((RepositoryListener)new AbstractRepositoryListener(){

            public void artifactInstalling(RepositoryEvent event) {
                MavenBridgeRepositorySystemSession.this.log().info("Installing " + event.getArtifact().getFile() + " to " + event.getFile());
            }

            public void metadataInstalling(RepositoryEvent event) {
                MavenBridgeRepositorySystemSession.this.log().debug("Installing " + event.getMetadata() + " to " + event.getFile());
            }

            public void artifactDescriptorInvalid(RepositoryEvent event) {
                if (MavenBridgeRepositorySystemSession.this.log().isDebugEnabled()) {
                    MavenBridgeRepositorySystemSession.this.log().warn("The POM for " + event.getArtifact() + " is invalid" + ", transitive dependencies (if any) will not be available: " + event.getException().getMessage());
                } else {
                    MavenBridgeRepositorySystemSession.this.log().warn("The POM for " + event.getArtifact() + " is invalid" + ", transitive dependencies (if any) will not be available" + ", enable debug logging for more details");
                }
            }

            public void artifactDescriptorMissing(RepositoryEvent event) {
                MavenBridgeRepositorySystemSession.this.log().warn("The POM for " + event.getArtifact() + " is missing, no dependency information available");
            }
        });
        this.setTransferListener((TransferListener)new AbstractTransferListener(){
            private ThreadLocal<Long> last = new ThreadLocal();

            public void transferInitiated(TransferEvent event) throws TransferCancelledException {
                MavenBridgeRepositorySystemSession.this.log().info("Downloading {}{}...", (Object)event.getResource().getRepositoryUrl(), (Object)event.getResource().getResourceName());
            }

            public void transferSucceeded(TransferEvent event) {
                MavenBridgeRepositorySystemSession.this.log().info("Downloaded [{} bytes] {}{}", new Object[]{event.getTransferredBytes(), event.getResource().getRepositoryUrl(), event.getResource().getResourceName()});
            }

            public void transferFailed(TransferEvent event) {
                MavenBridgeRepositorySystemSession.this.log().debug("Failed to download {}{}: {}", new Object[]{event.getResource().getRepositoryUrl(), event.getResource().getResourceName(), event.getException().getMessage()});
            }

            public void transferProgressed(TransferEvent event) throws TransferCancelledException {
                Long last = this.last.get();
                if (last == null || last < System.currentTimeMillis() - 5000L) {
                    String progress = event.getResource().getContentLength() > 0L ? (int)((double)event.getTransferredBytes() * 100.0 / (double)event.getResource().getContentLength()) + "%" : event.getTransferredBytes() + " bytes";
                    MavenBridgeRepositorySystemSession.this.log().debug("Downloading [{}] {}{}...", new Object[]{progress, event.getResource().getRepositoryUrl(), event.getResource().getResourceName()});
                    this.last.set(System.currentTimeMillis());
                }
            }
        });
    }

    @Inject
    public void setLocalRepository(@Nullable @Named(value="${mavenbridge.localRepository}") File localRepository, @Nullable @Named(value="${maven.repo.local}") File localRepositoryMaven) {
        if (localRepository != null) {
            this.setLocalRepositoryManager(this.repositorySystem.newLocalRepositoryManager(new LocalRepository(localRepository)));
        } else if (localRepositoryMaven != null) {
            this.setLocalRepositoryManager(this.repositorySystem.newLocalRepositoryManager(new LocalRepository(localRepositoryMaven)));
        }
    }

    @Inject
    void injectUpdatePolicy(@Named(value="${mavenbridge.updatePolicy:-daily}") String updatePolicy) {
        super.setUpdatePolicy(updatePolicy);
    }

    @Inject
    void injectChecksumPolicy(@Named(value="${mavenbridge.checksumPolicy:-warn}") String checksumPolicy) {
        super.setChecksumPolicy(checksumPolicy);
    }

    @Inject
    void injectOffline(@Named(value="${mavenbridge.offline:-false}") Boolean offline) {
        super.setOffline(offline.booleanValue());
    }

    protected Logger log() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        }
        return this.log;
    }
}

