/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.maven.bridge.support.model.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.DefaultModelBuilder;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.FileModelSource;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.resolution.InvalidRepositoryException;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.sisu.maven.bridge.MavenArtifactResolver;
import org.sonatype.sisu.maven.bridge.MavenModelResolver;
import org.sonatype.sisu.maven.bridge.internal.ComponentSupport;
import org.sonatype.sisu.maven.bridge.support.ArtifactRequestBuilder;
import org.sonatype.sisu.maven.bridge.support.RemoteRepositoryBuilder;

public abstract class MavenModelResolverSupport
extends ComponentSupport
implements MavenModelResolver {
    protected static final Provider<RepositorySystemSession> NO_SESSION_PROVIDER = null;
    private final DefaultModelBuilder modelBuilder;
    private final MavenArtifactResolver artifactResolver;
    private Provider<RepositorySystemSession> sessionProvider;

    protected MavenModelResolverSupport(MavenArtifactResolver artifactResolver) {
        this(artifactResolver, NO_SESSION_PROVIDER);
    }

    protected MavenModelResolverSupport(MavenArtifactResolver artifactResolver, @Nullable Provider<RepositorySystemSession> sessionProvider) {
        this.artifactResolver = MavenModelResolverSupport.assertNotNull(artifactResolver, "remote maven artifact resolver not specified");
        this.modelBuilder = new DefaultModelBuilderFactory().newInstance();
        this.sessionProvider = sessionProvider;
    }

    @Override
    public Model resolveModel(ModelBuildingRequest request, RepositorySystemSession session, RemoteRepository ... repositories) throws ModelBuildingException {
        MavenModelResolverSupport.assertNotNull(session, session.getClass());
        request.setModelResolver((ModelResolver)new ModelResolverProxy(session, repositories));
        if (request.getModelSource() instanceof ArtifactModelSource) {
            ArtifactModelSource source = (ArtifactModelSource)request.getModelSource();
            source.resolver = new ModelResolverProxy(session, repositories);
        }
        ModelBuildingResult modelResult = this.modelBuilder.build(request);
        return modelResult.getEffectiveModel();
    }

    @Override
    public Model resolveModel(ModelBuildingRequest request, RemoteRepository ... repositories) throws ModelBuildingException {
        return this.resolveModel(request, (RepositorySystemSession)MavenModelResolverSupport.assertNotNull(this.sessionProvider, "Repository system session provider not specified").get(), new RemoteRepository[0]);
    }

    public MavenArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    private class ModelResolverProxy
    implements ModelResolver {
        private final RepositorySystemSession session;
        private final RemoteRepository[] repositories;
        private final List<RemoteRepository> allRepositories;

        public ModelResolverProxy(RepositorySystemSession session, RemoteRepository ... repositories) {
            this.session = session;
            this.repositories = repositories;
            this.allRepositories = new ArrayList<RemoteRepository>();
            if (repositories != null) {
                this.allRepositories.addAll(Arrays.asList(repositories));
            }
        }

        public ModelSource resolveModel(String groupId, String artifactId, String version) throws UnresolvableModelException {
            try {
                Artifact pom = MavenModelResolverSupport.this.artifactResolver.resolveArtifact((ArtifactRequest)ArtifactRequestBuilder.request().artifact(groupId, artifactId, version, "pom"), this.session, RemoteRepositoryBuilder.remoteRepositories(this.allRepositories));
                return new FileModelSource(pom.getFile());
            }
            catch (ArtifactResolutionException e) {
                throw new UnresolvableModelException(e.getMessage(), groupId, artifactId, version, (Throwable)e);
            }
        }

        public void addRepository(Repository repository) throws InvalidRepositoryException {
            this.allRepositories.add(RemoteRepositoryBuilder.remoteRepository(repository));
        }

        public ModelResolver newCopy() {
            return new ModelResolverProxy(this.session, this.repositories);
        }
    }

    public static class ArtifactModelSource
    implements ModelSource {
        private ArtifactRequest artifactRequest;
        private ModelResolver resolver;
        private ModelSource source;

        public ArtifactModelSource(ArtifactRequest artifactRequest) {
            this.artifactRequest = artifactRequest;
        }

        public InputStream getInputStream() throws IOException {
            try {
                this.resolve();
            }
            catch (UnresolvableModelException e) {
                throw new IOException(e);
            }
            return this.source == null ? null : this.source.getInputStream();
        }

        public String getLocation() {
            try {
                this.resolve();
            }
            catch (UnresolvableModelException unresolvableModelException) {
                // empty catch block
            }
            return this.source == null ? null : this.source.getLocation();
        }

        private void resolve() throws UnresolvableModelException {
            if (this.source == null && this.resolver != null) {
                Artifact artifact = this.artifactRequest.getArtifact();
                this.source = this.resolver.resolveModel(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
            }
        }
    }
}

