/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.maven.bridge.support.dependency.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.artifact.ArtifactType;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.CollectResult;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.Exclusion;
import org.sonatype.aether.impl.RemoteRepositoryManager;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.aether.util.artifact.DefaultArtifact;
import org.sonatype.aether.util.artifact.DefaultArtifactType;
import org.sonatype.sisu.maven.bridge.MavenDependencyTreeResolver;
import org.sonatype.sisu.maven.bridge.MavenModelResolver;
import org.sonatype.sisu.maven.bridge.internal.ComponentSupport;
import org.sonatype.sisu.maven.bridge.support.CollectRequestBuilder;
import org.sonatype.sisu.maven.bridge.support.RemoteRepositoryBuilder;

public abstract class MavenDependencyTreeResolverSupport
extends ComponentSupport
implements MavenDependencyTreeResolver {
    protected static final Provider<RepositorySystemSession> NO_SESSION_PROVIDER = null;
    private MavenModelResolver mavenModelResolver;
    private Provider<RepositorySystemSession> sessionProvider;
    private RepositorySystem repositorySystem;
    private RemoteRepositoryManager remoteRepositoryManager;

    protected MavenDependencyTreeResolverSupport(ServiceLocator serviceLocator, @Nullable MavenModelResolver mavenModelResolver) {
        this(serviceLocator, mavenModelResolver, NO_SESSION_PROVIDER);
    }

    protected MavenDependencyTreeResolverSupport(ServiceLocator serviceLocator, @Nullable MavenModelResolver mavenModelResolver, @Nullable Provider<RepositorySystemSession> sessionProvider) {
        this.repositorySystem = (RepositorySystem)serviceLocator.getService(RepositorySystem.class);
        this.remoteRepositoryManager = (RemoteRepositoryManager)serviceLocator.getService(RemoteRepositoryManager.class);
        this.sessionProvider = sessionProvider;
        this.mavenModelResolver = mavenModelResolver;
    }

    @Override
    public DependencyNode resolveDependencyTree(CollectRequest request, RepositorySystemSession session, RemoteRepository ... repositories) throws DependencyCollectionException {
        if (request instanceof CollectRequestBuilder) {
            CollectRequestBuilder requestBuilder = (CollectRequestBuilder)request;
            ModelBuildingRequest modelBuildingRequest = requestBuilder.getModelBuildingRequest();
            Model model = requestBuilder.getModel();
            if (model == null && modelBuildingRequest != null) {
                model = this.resolveModel(request, session, modelBuildingRequest);
            }
            if (model != null) {
                this.injectCollectionRequest(request, session, model);
            }
        }
        return this.repositorySystem.collectDependencies(session, request).getRoot();
    }

    @Override
    public DependencyNode resolveDependencyTree(CollectRequest request, RemoteRepository ... repositories) throws DependencyCollectionException {
        return this.resolveDependencyTree(request, (RepositorySystemSession)MavenDependencyTreeResolverSupport.assertNotNull(this.sessionProvider, "Repository system session provider not specified").get(), new RemoteRepository[0]);
    }

    protected RemoteRepositoryManager getRemoteRepositoryManager() {
        return this.remoteRepositoryManager;
    }

    protected RepositorySystem getRepositorySystem() {
        return this.repositorySystem;
    }

    private void injectCollectionRequest(CollectRequest request, RepositorySystemSession session, Model model) {
        for (Repository repository : model.getRepositories()) {
            request.addRepository(RemoteRepositoryBuilder.remoteRepository(repository));
        }
        ArtifactTypeRegistry stereotypes = session.getArtifactTypeRegistry();
        for (org.apache.maven.model.Dependency dep : model.getDependencies()) {
            request.addDependency(this.toDependency(dep, stereotypes));
        }
        if (model.getDependencyManagement() != null) {
            for (org.apache.maven.model.Dependency dep : model.getDependencyManagement().getDependencies()) {
                request.addManagedDependency(this.toDependency(dep, stereotypes));
            }
        }
    }

    private Model resolveModel(CollectRequest request, RepositorySystemSession session, ModelBuildingRequest modelBuildingRequest) throws DependencyCollectionException {
        Model model;
        try {
            model = MavenDependencyTreeResolverSupport.assertNotNull(this.mavenModelResolver, "Maven model resolver is not set").resolveModel(modelBuildingRequest, session, new RemoteRepository[0]);
        }
        catch (ModelBuildingException e) {
            CollectResult collectResult = new CollectResult(request);
            collectResult.addException((Exception)((Object)e));
            throw new DependencyCollectionException(collectResult){

                public String getMessage() {
                    return e.getMessage();
                }
            };
        }
        return model;
    }

    private Dependency toDependency(org.apache.maven.model.Dependency dependency, ArtifactTypeRegistry stereotypes) {
        ArtifactType stereotype = stereotypes.get(dependency.getType());
        if (stereotype == null) {
            stereotype = new DefaultArtifactType(dependency.getType());
        }
        boolean system = dependency.getSystemPath() != null && dependency.getSystemPath().length() > 0;
        Map<String, String> props = null;
        if (system) {
            props = Collections.singletonMap("localPath", dependency.getSystemPath());
        }
        DefaultArtifact artifact = new DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), props, stereotype);
        ArrayList<Exclusion> exclusions = new ArrayList<Exclusion>(dependency.getExclusions().size());
        for (org.apache.maven.model.Exclusion exclusion : dependency.getExclusions()) {
            exclusions.add(this.toExclusion(exclusion));
        }
        return new Dependency((Artifact)artifact, dependency.getScope(), dependency.isOptional(), exclusions);
    }

    private Exclusion toExclusion(org.apache.maven.model.Exclusion exclusion) {
        return new Exclusion(exclusion.getGroupId(), exclusion.getArtifactId(), "*", "*");
    }
}

