/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.maven.bridge.support.dependency;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.sisu.maven.bridge.MavenDependencyTreeResolver;
import org.sonatype.sisu.maven.bridge.Names;
import org.sonatype.sisu.maven.bridge.internal.RepositorySystemSessionWrapper;
import org.sonatype.sisu.maven.bridge.support.dependency.internal.MavenDependencyTreeResolverSupport;
import org.sonatype.sisu.maven.bridge.support.model.RemoteMavenModelResolver;

@Named(value="remote-dependency-tree-resolver")
@Singleton
public class RemoteMavenDependencyTreeResolver
extends MavenDependencyTreeResolverSupport
implements MavenDependencyTreeResolver {
    private static final boolean RECESSIVE_IS_RAW = true;

    public RemoteMavenDependencyTreeResolver(ServiceLocator serviceLocator, @Nullable RemoteMavenModelResolver mavenModelResolver) {
        super(serviceLocator, mavenModelResolver);
    }

    @Inject
    public RemoteMavenDependencyTreeResolver(ServiceLocator serviceLocator, @Nullable RemoteMavenModelResolver mavenModelResolver, @Nullable Provider<RepositorySystemSession> sessionProvider) {
        super(serviceLocator, mavenModelResolver, sessionProvider);
    }

    @Override
    public DependencyNode resolveDependencyTree(CollectRequest request, RepositorySystemSession session, RemoteRepository ... repositories) throws DependencyCollectionException {
        ArrayList<RemoteRepository> allRepositories = new ArrayList<RemoteRepository>();
        if (repositories != null && repositories.length > 0) {
            allRepositories.addAll(Arrays.asList(repositories));
        }
        allRepositories.addAll(request.getRepositories());
        request.setRepositories(this.getRemoteRepositoryManager().aggregateRepositories(session, Collections.emptyList(), allRepositories, true));
        RepositorySystemSession safeSession = session;
        if (session.getLocalRepositoryManager() == null || session.getLocalRepository() == null) {
            safeSession = new RepositorySystemSessionWrapper(session){
                final LocalRepositoryManager lrm;
                {
                    this.lrm = RemoteMavenDependencyTreeResolver.this.getRepositorySystem().newLocalRepositoryManager(new LocalRepository(new File(Names.MAVEN_USER_HOME, "repository")));
                }

                @Override
                public LocalRepositoryManager getLocalRepositoryManager() {
                    return this.lrm;
                }

                @Override
                public LocalRepository getLocalRepository() {
                    return this.lrm.getRepository();
                }
            };
        }
        return super.resolveDependencyTree(request, safeSession, repositories);
    }
}

