/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.maven.bridge.support.artifact.internal;

import java.io.File;
import java.util.Arrays;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.transfer.ArtifactNotFoundException;
import org.sonatype.aether.util.layout.MavenDefaultLayout;
import org.sonatype.aether.util.layout.RepositoryLayout;
import org.sonatype.sisu.maven.bridge.support.artifact.internal.MavenArtifactResolverSupport;

public abstract class LocalMavenArtifactResolverSupport
extends MavenArtifactResolverSupport {
    private final RepositoryLayout layout = new MavenDefaultLayout();

    @Override
    protected Artifact doResolve(ArtifactRequest artifactRequest, RepositorySystemSession session, RemoteRepository ... repositories) throws ArtifactResolutionException {
        String path = this.layout.getPath(artifactRequest.getArtifact()).getPath();
        final File basedir = this.getBaseDir();
        File file = new File(basedir, path);
        if (!file.isFile()) {
            ArtifactResult artifactResult = new ArtifactResult(artifactRequest);
            artifactResult.addException((Exception)new ArtifactNotFoundException(artifactRequest.getArtifact(), new RemoteRepository(){

                public String toString() {
                    return basedir.getAbsolutePath();
                }
            }));
            throw new ArtifactResolutionException(Arrays.asList(artifactResult));
        }
        return artifactRequest.getArtifact().setFile(file);
    }

    protected abstract File getBaseDir();
}

