/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.maven.bridge.support.artifact;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.impl.RemoteRepositoryManager;
import org.sonatype.aether.repository.LocalRepository;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactRequest;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.spi.locator.ServiceLocator;
import org.sonatype.sisu.maven.bridge.MavenArtifactResolver;
import org.sonatype.sisu.maven.bridge.Names;
import org.sonatype.sisu.maven.bridge.internal.RepositorySystemSessionWrapper;
import org.sonatype.sisu.maven.bridge.support.artifact.internal.MavenArtifactResolverSupport;

@Named(value="remote-artifact-resolver")
@Singleton
public class RemoteMavenArtifactResolver
extends MavenArtifactResolverSupport
implements MavenArtifactResolver {
    static final boolean RECESSIVE_IS_RAW = true;
    private RepositorySystem repositorySystem;
    private RemoteRepositoryManager remoteRepositoryManager;

    public RemoteMavenArtifactResolver(ServiceLocator serviceLocator) {
        this(serviceLocator, (Provider<RepositorySystemSession>)NO_SESSION_PROVIDER);
    }

    @Inject
    public RemoteMavenArtifactResolver(ServiceLocator serviceLocator, @Nullable Provider<RepositorySystemSession> sessionProvider) {
        super(sessionProvider);
        this.repositorySystem = (RepositorySystem)serviceLocator.getService(RepositorySystem.class);
        this.remoteRepositoryManager = (RemoteRepositoryManager)serviceLocator.getService(RemoteRepositoryManager.class);
    }

    @Override
    protected Artifact doResolve(ArtifactRequest artifactRequest, RepositorySystemSession session, RemoteRepository ... repositories) throws ArtifactResolutionException {
        ArrayList<RemoteRepository> allRepositories = new ArrayList<RemoteRepository>();
        if (repositories != null && repositories.length > 0) {
            allRepositories.addAll(Arrays.asList(repositories));
        }
        allRepositories.addAll(artifactRequest.getRepositories());
        artifactRequest.setRepositories(this.remoteRepositoryManager.aggregateRepositories(session, Collections.emptyList(), allRepositories, true));
        RepositorySystemSession safeSession = session;
        if (session.getLocalRepositoryManager() == null || session.getLocalRepository() == null) {
            safeSession = new RepositorySystemSessionWrapper(session){
                final LocalRepositoryManager lrm;
                {
                    this.lrm = RemoteMavenArtifactResolver.this.repositorySystem.newLocalRepositoryManager(new LocalRepository(new File(Names.MAVEN_USER_HOME, "repository")));
                }

                @Override
                public LocalRepositoryManager getLocalRepositoryManager() {
                    return this.lrm;
                }

                @Override
                public LocalRepository getLocalRepository() {
                    return this.lrm.getRepository();
                }
            };
        }
        return this.repositorySystem.resolveArtifact(safeSession, artifactRequest).getArtifact();
    }
}

