/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.maven.bridge.support;

import java.util.Collection;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.RepositoryPolicy;
import org.sonatype.aether.repository.RemoteRepository;

public class RemoteRepositoryBuilder {
    public static RemoteRepository remoteRepository(String url) {
        return RemoteRepositoryBuilder.remoteRepository(null, "default", url);
    }

    public static RemoteRepository[] remoteRepositories(Collection<RemoteRepository> repositories) {
        if (repositories == null) {
            return new RemoteRepository[0];
        }
        return repositories.toArray(new RemoteRepository[repositories.size()]);
    }

    public static RemoteRepository remoteRepository(String id, String type, String url) {
        RemoteRepository repository = new RemoteRepository(id, type, url);
        repository.setPolicy(false, new org.sonatype.aether.repository.RepositoryPolicy(true, "daily", "warn"));
        return repository;
    }

    public static RemoteRepository remoteRepository(org.apache.maven.model.Repository repository) {
        RemoteRepository remoteRepository = new RemoteRepository(repository.getId(), repository.getLayout(), repository.getUrl());
        remoteRepository.setPolicy(true, RemoteRepositoryBuilder.convert(repository.getSnapshots()));
        remoteRepository.setPolicy(false, RemoteRepositoryBuilder.convert(repository.getReleases()));
        return remoteRepository;
    }

    public static RemoteRepository remoteRepository(Repository repository) {
        RemoteRepository remoteRepository = new RemoteRepository(repository.getId(), repository.getLayout(), repository.getUrl());
        remoteRepository.setPolicy(true, RemoteRepositoryBuilder.convert(repository.getSnapshots()));
        remoteRepository.setPolicy(false, RemoteRepositoryBuilder.convert(repository.getReleases()));
        return remoteRepository;
    }

    private static org.sonatype.aether.repository.RepositoryPolicy convert(org.apache.maven.model.RepositoryPolicy policy) {
        boolean enabled = true;
        String checksum = "warn";
        String updates = "daily";
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updates = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksum = policy.getChecksumPolicy();
            }
        }
        return new org.sonatype.aether.repository.RepositoryPolicy(enabled, updates, checksum);
    }

    private static org.sonatype.aether.repository.RepositoryPolicy convert(RepositoryPolicy policy) {
        boolean enabled = true;
        String checksum = "warn";
        String updates = "daily";
        if (policy != null) {
            enabled = policy.isEnabled();
            if (policy.getUpdatePolicy() != null) {
                updates = policy.getUpdatePolicy();
            }
            if (policy.getChecksumPolicy() != null) {
                checksum = policy.getChecksumPolicy();
            }
        }
        return new org.sonatype.aether.repository.RepositoryPolicy(enabled, updates, checksum);
    }
}

