/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.util.Map;
import org.skife.jdbi.cglib.proxy.MethodProxy;
import org.skife.jdbi.com.fasterxml.classmate.members.ResolvedMethod;
import org.skife.jdbi.v2.ConcreteStatementContext;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.sqlobject.CustomizingStatementHandler;
import org.skife.jdbi.v2.sqlobject.HandleDing;
import org.skife.jdbi.v2.sqlobject.ResultReturnThing;
import org.skife.jdbi.v2.sqlobject.SqlObject;
import org.skife.jdbi.v2.sqlobject.SqlQuery;

class QueryHandler
extends CustomizingStatementHandler {
    private final String sql;
    private final ResolvedMethod method;
    private final ResultReturnThing magic;

    public QueryHandler(Class<?> sqlObjectType, ResolvedMethod method, ResultReturnThing magic) {
        super(sqlObjectType, method);
        this.method = method;
        this.magic = magic;
        this.sql = SqlObject.getSql(method.getRawMember().getAnnotation(SqlQuery.class), method.getRawMember());
    }

    @Override
    public Object invoke(HandleDing h, Object target, Object[] args, MethodProxy mp) {
        Query<Map<String, Object>> q = h.getHandle().createQuery(this.sql);
        this.populateSqlObjectData((ConcreteStatementContext)q.getContext());
        this.applyCustomizers(q, args);
        this.applyBinders(q, args);
        return this.magic.map(this.method, q, h);
    }
}

