/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.sql.DataSource;
import org.skife.jdbi.v2.BasicHandle;
import org.skife.jdbi.v2.ClasspathStatementLocator;
import org.skife.jdbi.v2.ColonPrefixNamedParamStatementRewriter;
import org.skife.jdbi.v2.ContainerFactoryRegistry;
import org.skife.jdbi.v2.DataSourceConnectionFactory;
import org.skife.jdbi.v2.DefaultStatementBuilderFactory;
import org.skife.jdbi.v2.Foreman;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.MappingRegistry;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.TimingCollector;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionIsolationLevel;
import org.skife.jdbi.v2.exceptions.CallbackFailedException;
import org.skife.jdbi.v2.exceptions.UnableToObtainConnectionException;
import org.skife.jdbi.v2.logging.NoOpLog;
import org.skife.jdbi.v2.sqlobject.SqlObjectBuilder;
import org.skife.jdbi.v2.tweak.ArgumentFactory;
import org.skife.jdbi.v2.tweak.ConnectionFactory;
import org.skife.jdbi.v2.tweak.ContainerFactory;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.tweak.SQLLog;
import org.skife.jdbi.v2.tweak.StatementBuilder;
import org.skife.jdbi.v2.tweak.StatementBuilderFactory;
import org.skife.jdbi.v2.tweak.StatementLocator;
import org.skife.jdbi.v2.tweak.StatementRewriter;
import org.skife.jdbi.v2.tweak.TransactionHandler;
import org.skife.jdbi.v2.tweak.transactions.LocalTransactionHandler;

public class DBI
implements IDBI {
    private final Map<String, Object> globalStatementAttributes = new ConcurrentHashMap<String, Object>();
    private final MappingRegistry mappingRegistry = new MappingRegistry();
    private final ContainerFactoryRegistry containerFactoryRegistry = new ContainerFactoryRegistry();
    private final Foreman foreman = new Foreman();
    private final ConnectionFactory connectionFactory;
    private AtomicReference<StatementRewriter> statementRewriter = new AtomicReference<ColonPrefixNamedParamStatementRewriter>(new ColonPrefixNamedParamStatementRewriter());
    private AtomicReference<StatementLocator> statementLocator = new AtomicReference<ClasspathStatementLocator>(new ClasspathStatementLocator());
    private AtomicReference<TransactionHandler> transactionhandler = new AtomicReference<LocalTransactionHandler>(new LocalTransactionHandler());
    private AtomicReference<StatementBuilderFactory> statementBuilderFactory = new AtomicReference<DefaultStatementBuilderFactory>(new DefaultStatementBuilderFactory());
    private AtomicReference<SQLLog> log = new AtomicReference<NoOpLog>(new NoOpLog());
    private AtomicReference<TimingCollector> timingCollector = new AtomicReference<TimingCollector>(TimingCollector.NOP_TIMING_COLLECTOR);

    public DBI(DataSource dataSource) {
        this(new DataSourceConnectionFactory(dataSource));
        assert (dataSource != null);
    }

    public DBI(ConnectionFactory connectionFactory) {
        assert (connectionFactory != null);
        this.connectionFactory = connectionFactory;
    }

    public DBI(final String url) {
        this(new ConnectionFactory(){

            @Override
            public Connection openConnection() throws SQLException {
                return DriverManager.getConnection(url);
            }
        });
    }

    public DBI(final String url, final Properties props) {
        this(new ConnectionFactory(){

            @Override
            public Connection openConnection() throws SQLException {
                return DriverManager.getConnection(url, props);
            }
        });
    }

    public DBI(final String url, final String username, final String password) {
        this(new ConnectionFactory(){

            @Override
            public Connection openConnection() throws SQLException {
                return DriverManager.getConnection(url, username, password);
            }
        });
    }

    public void setStatementLocator(StatementLocator locator) {
        assert (locator != null);
        this.statementLocator.set(locator);
    }

    public StatementLocator getStatementLocator() {
        return this.statementLocator.get();
    }

    public void setStatementRewriter(StatementRewriter rewriter) {
        assert (rewriter != null);
        this.statementRewriter.set(rewriter);
    }

    public StatementRewriter getStatementRewriter() {
        return this.statementRewriter.get();
    }

    public void setTransactionHandler(TransactionHandler handler) {
        assert (handler != null);
        this.transactionhandler.set(handler);
    }

    public TransactionHandler getTransactionHandler() {
        return this.transactionhandler.get();
    }

    @Override
    public Handle open() {
        try {
            long start = System.nanoTime();
            Connection conn = this.connectionFactory.openConnection();
            long stop = System.nanoTime();
            StatementBuilder cache = this.statementBuilderFactory.get().createStatementBuilder(conn);
            BasicHandle h = new BasicHandle(this.transactionhandler.get(), this.statementLocator.get(), cache, this.statementRewriter.get(), conn, this.globalStatementAttributes, this.log.get(), this.timingCollector.get(), new MappingRegistry(this.mappingRegistry), this.foreman.createChild(), this.containerFactoryRegistry.createChild());
            this.log.get().logObtainHandle((stop - start) / 1000000L, h);
            return h;
        }
        catch (SQLException e) {
            throw new UnableToObtainConnectionException(e);
        }
    }

    public void registerMapper(ResultSetMapper mapper) {
        this.mappingRegistry.add(mapper);
    }

    public void registerMapper(ResultSetMapperFactory factory) {
        this.mappingRegistry.add(factory);
    }

    @Override
    public void define(String key, Object value) {
        this.globalStatementAttributes.put(key, value);
    }

    @Override
    public <ReturnType> ReturnType withHandle(HandleCallback<ReturnType> callback) throws CallbackFailedException {
        Handle h = this.open();
        try {
            ReturnType ReturnType = callback.withHandle(h);
            return ReturnType;
        }
        catch (Exception e) {
            throw new CallbackFailedException(e);
        }
        finally {
            h.close();
        }
    }

    @Override
    public <ReturnType> ReturnType inTransaction(final TransactionCallback<ReturnType> callback) throws CallbackFailedException {
        return this.withHandle(new HandleCallback<ReturnType>(){

            @Override
            public ReturnType withHandle(Handle handle) throws Exception {
                return handle.inTransaction(callback);
            }
        });
    }

    @Override
    public <ReturnType> ReturnType inTransaction(final TransactionIsolationLevel isolation, final TransactionCallback<ReturnType> callback) throws CallbackFailedException {
        return this.withHandle(new HandleCallback<ReturnType>(){

            @Override
            public ReturnType withHandle(Handle handle) throws Exception {
                return handle.inTransaction(isolation, callback);
            }
        });
    }

    @Override
    public <SqlObjectType> SqlObjectType open(Class<SqlObjectType> sqlObjectType) {
        return SqlObjectBuilder.open(this, sqlObjectType);
    }

    @Override
    public <SqlObjectType> SqlObjectType onDemand(Class<SqlObjectType> sqlObjectType) {
        return SqlObjectBuilder.onDemand(this, sqlObjectType);
    }

    @Override
    public void close(Object sqlObject) {
        if (sqlObject instanceof Handle) {
            Handle h = (Handle)sqlObject;
            h.close();
        } else {
            SqlObjectBuilder.close(sqlObject);
        }
    }

    public static Handle open(DataSource dataSource) {
        assert (dataSource != null);
        return new DBI(dataSource).open();
    }

    public static Handle open(final Connection connection) {
        assert (connection != null);
        return new DBI(new ConnectionFactory(){

            @Override
            public Connection openConnection() {
                return connection;
            }
        }).open();
    }

    public static Handle open(String url) {
        assert (url != null);
        return new DBI(url).open();
    }

    public static Handle open(String url, String username, String password) {
        assert (url != null);
        return new DBI(url, username, password).open();
    }

    public static Handle open(String url, Properties props) {
        assert (url != null);
        return new DBI(url, props).open();
    }

    public void setStatementBuilderFactory(StatementBuilderFactory factory) {
        this.statementBuilderFactory.set(factory);
    }

    public StatementBuilderFactory getStatementBuilderFactory() {
        return this.statementBuilderFactory.get();
    }

    public void setSQLLog(SQLLog log) {
        this.log.set(log);
    }

    public SQLLog getSQLLog() {
        return this.log.get();
    }

    public void setTimingCollector(TimingCollector timingCollector) {
        if (timingCollector == null) {
            this.timingCollector.set(TimingCollector.NOP_TIMING_COLLECTOR);
        } else {
            this.timingCollector.set(timingCollector);
        }
    }

    public TimingCollector getTimingCollector() {
        return this.timingCollector.get();
    }

    public void registerArgumentFactory(ArgumentFactory<?> argumentFactory) {
        this.foreman.register(argumentFactory);
    }

    public void registerContainerFactory(ContainerFactory<?> factory) {
        this.containerFactoryRegistry.register(factory);
    }
}

