/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.com.fasterxml.classmate.members;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import org.skife.jdbi.com.fasterxml.classmate.Annotations;
import org.skife.jdbi.com.fasterxml.classmate.ResolvedType;

public abstract class ResolvedMember {
    protected final ResolvedType _declaringType;
    protected final Annotations _annotations;

    protected ResolvedMember(ResolvedType context, Annotations ann) {
        this._declaringType = context;
        this._annotations = ann;
    }

    public void applyOverride(Annotation override) {
        this._annotations.add(override);
    }

    public void applyOverrides(Annotations overrides) {
        this._annotations.addAll(overrides);
    }

    public void applyDefault(Annotation override) {
        this._annotations.addAsDefault(override);
    }

    public <A extends Annotation> A get(Class<A> cls) {
        return this._annotations.get(cls);
    }

    public final ResolvedType getDeclaringType() {
        return this._declaringType;
    }

    public abstract ResolvedType getType();

    public abstract Member getRawMember();

    public String getName() {
        return this.getRawMember().getName();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.getModifiers());
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public String toString() {
        return this.getName();
    }

    protected final int getModifiers() {
        return this.getRawMember().getModifiers();
    }
}

