/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.siesta;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.servlet.ServletModule;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.guice.FilterChainModule;
import org.sonatype.nexus.web.internal.SecurityFilter;
import org.sonatype.sisu.siesta.common.Resource;
import org.sonatype.sisu.siesta.jackson.SiestaJacksonModule;
import org.sonatype.sisu.siesta.server.internal.ComponentDiscoveryApplication;
import org.sonatype.sisu.siesta.server.internal.ComponentDiscoveryReporter;
import org.sonatype.sisu.siesta.server.internal.ComponentDiscoveryReporterImpl;
import org.sonatype.sisu.siesta.server.internal.SiestaServlet;
import org.sonatype.sisu.siesta.server.internal.jersey.SiestaJerseyModule;

@Named
public class SiestaModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(SiestaModule.class);
    public static final String SERVICE_NAME = "siesta";
    public static final String MOUNT_POINT = "/service/siesta";
    public static final String SKIP_MODULE_CONFIGURATION = SiestaModule.class.getName() + ".skip";

    protected void configure() {
        if (!Boolean.getBoolean(SKIP_MODULE_CONFIGURATION)) {
            this.doConfigure();
        }
    }

    private void doConfigure() {
        this.install((Module)new org.sonatype.sisu.siesta.server.internal.SiestaModule());
        this.install((Module)new SiestaJerseyModule());
        this.install((Module)new SiestaJacksonModule());
        this.bind(Application.class).to(ComponentDiscoveryApplication.class).in(Singleton.class);
        this.bind(ComponentDiscoveryReporter.class).toInstance((Object)new ComponentDiscoveryReporterImpl(log){

            protected String pathOf(Class<Resource> type) {
                String path = super.pathOf(type);
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                return SiestaModule.MOUNT_POINT + path;
            }
        });
        this.install((Module)new ServletModule(){

            protected void configureServlets() {
                this.serve("/service/siesta/*", new String[0]).with(SiestaServlet.class);
                this.filter("/service/siesta/*", new String[0]).through(SecurityFilter.class);
            }
        });
        this.install((Module)new FilterChainModule(){

            protected void configure() {
                this.addFilterChain("/service/siesta/**", "noSessionCreation,authcBasic");
            }
        });
    }
}

