/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.siesta;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.configuration.validation.ValidationMessage;
import org.sonatype.configuration.validation.ValidationResponse;
import org.sonatype.sisu.siesta.common.validation.ValidationErrorXO;
import org.sonatype.sisu.siesta.server.ValidationErrorsExceptionMappersSupport;

@Named
@Singleton
public class InvalidConfigurationExceptionMapper
extends ValidationErrorsExceptionMappersSupport<InvalidConfigurationException> {
    protected List<ValidationErrorXO> getValidationErrors(InvalidConfigurationException exception) {
        List validationErrors;
        ValidationResponse validationResponse = exception.getValidationResponse();
        if (validationResponse != null && (validationErrors = validationResponse.getValidationErrors()) != null && !validationErrors.isEmpty()) {
            return Lists.transform((List)validationErrors, (Function)new Function<ValidationMessage, ValidationErrorXO>(){

                @Nullable
                public ValidationErrorXO apply(@Nullable ValidationMessage validationMessage) {
                    if (validationMessage != null) {
                        return new ValidationErrorXO(validationMessage.getKey(), validationMessage.getMessage());
                    }
                    return null;
                }
            });
        }
        return Lists.newArrayList((Object[])new ValidationErrorXO[]{new ValidationErrorXO(exception.getMessage())});
    }
}

