/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.siesta;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.AuthorizationException;
import org.sonatype.sisu.siesta.server.ErrorExceptionMapperSupport;

@Named
@Singleton
public class AuthorizationExceptionMapper
extends ErrorExceptionMapperSupport<AuthorizationException> {
    private static final String AUTH_SCHEME_KEY = "auth.scheme";
    public static final String AUTH_REALM_KEY = "auth.realm";
    private static final String ANONYMOUS_LOGIN = "nexus.anonymous";
    private static final String AUTHENTICATE_HEADER = "WWW-Authenticate";
    @Inject
    private Provider<HttpServletRequest> httpServletRequestProvider;

    protected Response convert(AuthorizationException exception, String id) {
        Response.ResponseBuilder builder = Response.fromResponse((Response)super.convert((Throwable)exception, id));
        HttpServletRequest servletRequest = (HttpServletRequest)this.httpServletRequestProvider.get();
        if (servletRequest.getAttribute(ANONYMOUS_LOGIN) != null) {
            String scheme = (String)servletRequest.getAttribute(AUTH_SCHEME_KEY);
            String realm = (String)servletRequest.getAttribute(AUTH_REALM_KEY);
            builder.status(Response.Status.UNAUTHORIZED).header(AUTHENTICATE_HEADER, (Object)String.format("%s realm=\"%s\"", scheme, realm));
        }
        return builder.build();
    }

    protected int getStatusCode(AuthorizationException exception) {
        return Response.Status.FORBIDDEN.getStatusCode();
    }
}

