/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rutauth.internal.capability;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.sonatype.nexus.capability.support.CapabilityConfigurationSupport;

public class RutAuthCapabilityConfiguration
extends CapabilityConfigurationSupport {
    @NonNls
    public static final String HTTP_HEADER = "httpHeader";
    @NonNls
    public static final String DEFAULT_HTTP_HEADER = "REMOTE_USER";
    private String httpHeader;

    public RutAuthCapabilityConfiguration(Map<String, String> properties) {
        Preconditions.checkNotNull(properties);
        this.httpHeader = properties.get(HTTP_HEADER);
        if (Strings.isNullOrEmpty((String)this.httpHeader)) {
            this.httpHeader = DEFAULT_HTTP_HEADER;
        }
    }

    public String getHttpHeader() {
        return this.httpHeader;
    }

    public RutAuthCapabilityConfiguration withHttpHeader(String httpHeader) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)httpHeader) ? 1 : 0) != 0, (Object)"httpHeader cannot be null or empty");
        this.httpHeader = httpHeader;
        return this;
    }

    public Map<String, String> asMap() {
        HashMap props = Maps.newHashMap();
        props.put(HTTP_HEADER, this.httpHeader);
        return props;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "{" + "httpHeader=" + this.httpHeader + "}";
    }
}

