/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rutauth.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.credential.CredentialsMatcher;
import org.apache.shiro.realm.AuthenticatingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.eclipse.sisu.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.rutauth.internal.RutAuthAuthenticationToken;
import org.sonatype.security.SecuritySystem;
import org.sonatype.security.usermanagement.User;
import org.sonatype.security.usermanagement.UserManager;
import org.sonatype.security.usermanagement.UserNotFoundException;

@Named(value="rutauth-realm")
@Singleton
@Description(value="Rut Auth Realm")
public class RutAuthRealm
extends AuthenticatingRealm {
    private static final Logger log = LoggerFactory.getLogger(RutAuthRealm.class);
    public static final String ID = "rutauth-realm";
    public static final String DESCRIPTION = "Rut Auth Realm";
    private final SecuritySystem securitySystem;
    private final List<UserManager> userManagers;

    @Inject
    public RutAuthRealm(SecuritySystem securitySystem, List<UserManager> userManagers) {
        this.securitySystem = (SecuritySystem)Preconditions.checkNotNull((Object)securitySystem, (Object)"securitySystem");
        this.userManagers = (List)Preconditions.checkNotNull(userManagers, (Object)"userManagers");
        this.setName(ID);
        this.setCredentialsMatcher(new CredentialsMatcher(){

            public boolean doCredentialsMatch(AuthenticationToken token, AuthenticationInfo info) {
                return true;
            }
        });
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof RutAuthAuthenticationToken;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        String rutUserId = token.getPrincipal().toString();
        SimplePrincipalCollection principals = new SimplePrincipalCollection();
        List configuredRealms = this.securitySystem.getRealms();
        for (UserManager userManager : this.userManagers) {
            if (!configuredRealms.contains(userManager.getAuthenticationRealmName())) continue;
            try {
                User user = userManager.getUser(rutUserId);
                principals.add((Object)user.getUserId(), userManager.getAuthenticationRealmName());
            }
            catch (UserNotFoundException userNotFoundException) {}
        }
        if (!principals.isEmpty()) {
            log.debug("Found principals for RUT user '{}': '{}' from realms '{}'", new Object[]{rutUserId, principals, principals.getRealmNames()});
            SimplePrincipalCollection principalCollection = new SimplePrincipalCollection(token.getPrincipal(), this.getName());
            principalCollection.addAll((PrincipalCollection)principals);
            return new SimpleAuthenticationInfo((PrincipalCollection)principalCollection, null);
        }
        log.debug("No found principals for RUT user '{}'", (Object)rutUserId);
        return null;
    }
}

