/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.rutauth.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.configuration.validation.InvalidConfigurationException;
import org.sonatype.nexus.rutauth.internal.RutAuthAuthenticationToken;
import org.sonatype.nexus.security.filter.authc.HttpHeaderAuthenticationToken;
import org.sonatype.nexus.security.filter.authc.HttpHeaderAuthenticationTokenFactorySupport;
import org.sonatype.security.SecuritySystem;

@Named
@Singleton
public class RutAuthAuthenticationTokenFactory
extends HttpHeaderAuthenticationTokenFactorySupport {
    private static final Logger log = LoggerFactory.getLogger(RutAuthAuthenticationTokenFactory.class);
    private final SecuritySystem securitySystem;
    private String headerName;

    @Inject
    public RutAuthAuthenticationTokenFactory(SecuritySystem securitySystem) {
        this.securitySystem = (SecuritySystem)Preconditions.checkNotNull((Object)securitySystem, (Object)"securitySystem");
    }

    protected List<String> getHttpHeaderNames() {
        if (this.headerName != null) {
            return Lists.newArrayList((Object[])new String[]{this.headerName});
        }
        return Collections.emptyList();
    }

    protected HttpHeaderAuthenticationToken createToken(String headerName, String headerValue, String host) {
        return new RutAuthAuthenticationToken(headerName, headerValue, host);
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
        this.maybeConfigureRealm();
    }

    private void maybeConfigureRealm() {
        List realms = this.securitySystem.getRealms();
        if (!realms.contains("rutauth-realm")) {
            ArrayList newRealms = Lists.newArrayList((Iterable)realms);
            newRealms.add("rutauth-realm");
            try {
                this.securitySystem.setRealms((List)newRealms);
                log.info("Automatically enabled '{}'", (Object)"Rut Auth Realm");
            }
            catch (InvalidConfigurationException e) {
                log.warn("Could not automatically enable '{}'", (Object)"Rut Auth Realm", (Object)e);
            }
        }
    }
}

