/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.support.validator;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.plugins.capabilities.CapabilityIdentity;
import org.sonatype.nexus.plugins.capabilities.CapabilityType;
import org.sonatype.nexus.plugins.capabilities.Validator;
import org.sonatype.nexus.plugins.capabilities.internal.validator.ValidatorFactory;

@Named
@Singleton
public class CapabilityValidators {
    private final ValidatorFactory validatorFactory;

    @Inject
    public CapabilityValidators(ValidatorFactory validatorFactory) {
        this.validatorFactory = (ValidatorFactory)Preconditions.checkNotNull((Object)validatorFactory);
    }

    public Validator alwaysValid() {
        return this.validatorFactory.alwaysValid();
    }

    public Validator uniquePer(CapabilityType type, String ... propertyKeys) {
        return this.validatorFactory.uniquePer(type, propertyKeys);
    }

    public Validator uniquePerExcluding(CapabilityIdentity excludeId, CapabilityType type, String ... propertyKeys) {
        return this.validatorFactory.uniquePerExcluding(excludeId, type, propertyKeys);
    }

    public Validator required(CapabilityType type, String propertyKey) {
        return this.validatorFactory.required(type, propertyKey);
    }

    public Validator matches(CapabilityType type, String propertyKey, String regexp) {
        return this.validatorFactory.matches(type, propertyKey, regexp);
    }

    public Validator constraintsOf(CapabilityType type) {
        return this.validatorFactory.constraintsOf(type);
    }
}

