/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.support.condition;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.plugins.capabilities.Condition;
import org.sonatype.nexus.plugins.capabilities.internal.condition.RepositoryExistsCondition;
import org.sonatype.nexus.plugins.capabilities.internal.condition.RepositoryLocalStatusCondition;
import org.sonatype.nexus.plugins.capabilities.internal.condition.RepositoryProxyModeCondition;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.LocalStatus;
import org.sonatype.nexus.proxy.repository.ProxyMode;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Named
@Singleton
public class RepositoryConditions {
    private final EventBus eventBus;
    private final RepositoryRegistry repositoryRegistry;

    @Inject
    public RepositoryConditions(EventBus eventBus, RepositoryRegistry repositoryRegistry) {
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.repositoryRegistry = (RepositoryRegistry)Preconditions.checkNotNull((Object)repositoryRegistry);
    }

    public Condition repositoryIsInService(RepositoryId repositoryId) {
        return new RepositoryLocalStatusCondition(this.eventBus, this.repositoryRegistry, LocalStatus.IN_SERVICE, repositoryId);
    }

    public Condition repositoryIsNotBlocked(RepositoryId repositoryId) {
        return new RepositoryProxyModeCondition(this.eventBus, this.repositoryRegistry, ProxyMode.ALLOW, repositoryId);
    }

    public Condition repositoryExists(RepositoryId repositoryId) {
        return new RepositoryExistsCondition(this.eventBus, this.repositoryRegistry, repositoryId);
    }

    public static interface RepositoryId {
        public String get();
    }
}

