/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.support.condition;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.plugins.capabilities.Condition;
import org.sonatype.nexus.plugins.capabilities.internal.condition.InversionCondition;
import org.sonatype.nexus.plugins.capabilities.support.condition.CompositeConditionSupport;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Named
@Singleton
public class LogicalConditions {
    private final EventBus eventBus;

    @Inject
    public LogicalConditions(EventBus eventBus) {
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
    }

    public Condition and(Condition ... conditions) {
        return new ConjunctionCondition(this.eventBus, conditions);
    }

    public Condition or(Condition ... conditions) {
        return new DisjunctionCondition(this.eventBus, conditions);
    }

    public Condition not(Condition condition) {
        return new InversionCondition(this.eventBus, condition);
    }

    private static class ConjunctionCondition
    extends CompositeConditionSupport
    implements Condition {
        private Condition lastNotSatisfied;

        public ConjunctionCondition(EventBus eventBus, Condition ... conditions) {
            super(eventBus, conditions);
        }

        @Override
        protected boolean reevaluate(Condition ... conditions) {
            Condition[] conditionArray = conditions;
            int n = conditions.length;
            int n2 = 0;
            while (n2 < n) {
                Condition condition = conditionArray[n2];
                if (!condition.isSatisfied()) {
                    this.lastNotSatisfied = condition;
                    return false;
                }
                ++n2;
            }
            this.lastNotSatisfied = null;
            return true;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            Condition[] conditionArray = this.getConditions();
            int n = conditionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Condition condition = conditionArray[n2];
                if (sb.length() > 0) {
                    sb.append(" AND ");
                }
                sb.append(condition);
                ++n2;
            }
            return sb.toString();
        }

        @Override
        public String explainSatisfied() {
            StringBuilder sb = new StringBuilder();
            Condition[] conditionArray = this.getConditions();
            int n = conditionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Condition condition = conditionArray[n2];
                if (sb.length() > 0) {
                    sb.append(" AND ");
                }
                sb.append(condition.explainSatisfied());
                ++n2;
            }
            return sb.toString();
        }

        @Override
        public String explainUnsatisfied() {
            if (this.lastNotSatisfied != null) {
                return this.lastNotSatisfied.explainUnsatisfied();
            }
            StringBuilder sb = new StringBuilder();
            Condition[] conditionArray = this.getConditions();
            int n = conditionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Condition condition = conditionArray[n2];
                if (sb.length() > 0) {
                    sb.append(" OR ");
                }
                sb.append(condition.explainUnsatisfied());
                ++n2;
            }
            return sb.toString();
        }
    }

    private static class DisjunctionCondition
    extends CompositeConditionSupport
    implements Condition {
        private Condition lastSatisfied;

        public DisjunctionCondition(EventBus eventBus, Condition ... conditions) {
            super(eventBus, conditions);
        }

        @Override
        protected boolean reevaluate(Condition ... conditions) {
            Condition[] conditionArray = conditions;
            int n = conditions.length;
            int n2 = 0;
            while (n2 < n) {
                Condition condition = conditionArray[n2];
                if (condition.isSatisfied()) {
                    this.lastSatisfied = condition;
                    return true;
                }
                ++n2;
            }
            this.lastSatisfied = null;
            return false;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            Condition[] conditionArray = this.getConditions();
            int n = conditionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Condition condition = conditionArray[n2];
                if (sb.length() > 0) {
                    sb.append(" OR ");
                }
                sb.append(condition);
                ++n2;
            }
            return sb.toString();
        }

        @Override
        public String explainSatisfied() {
            if (this.lastSatisfied != null) {
                return this.lastSatisfied.explainSatisfied();
            }
            StringBuilder sb = new StringBuilder();
            Condition[] conditionArray = this.getConditions();
            int n = conditionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Condition condition = conditionArray[n2];
                if (sb.length() > 0) {
                    sb.append(" OR ");
                }
                sb.append(condition.explainSatisfied());
                ++n2;
            }
            return sb.toString();
        }

        @Override
        public String explainUnsatisfied() {
            StringBuilder sb = new StringBuilder();
            Condition[] conditionArray = this.getConditions();
            int n = conditionArray.length;
            int n2 = 0;
            while (n2 < n) {
                Condition condition = conditionArray[n2];
                if (sb.length() > 0) {
                    sb.append(" AND ");
                }
                sb.append(condition.explainUnsatisfied());
                ++n2;
            }
            return sb.toString();
        }
    }
}

