/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.support.condition;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jetbrains.annotations.NonNls;
import org.sonatype.nexus.plugins.capabilities.Condition;
import org.sonatype.nexus.plugins.capabilities.internal.condition.CipherKeyHighStrengthCondition;
import org.sonatype.nexus.plugins.capabilities.internal.condition.CipherKeyUnlimitedStrengthCondition;
import org.sonatype.nexus.plugins.capabilities.internal.condition.CipherRequiredCondition;
import org.sonatype.sisu.goodies.crypto.CryptoHelper;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Named
@Singleton
public class CryptoConditions {
    private final EventBus eventBus;
    private final CryptoHelper crypto;

    @Inject
    public CryptoConditions(EventBus eventBus, CryptoHelper crypto) {
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
        this.crypto = (CryptoHelper)Preconditions.checkNotNull((Object)crypto);
    }

    public Condition requireCipher(@NonNls String algorithm) {
        return new CipherRequiredCondition(this.eventBus, this.crypto, algorithm);
    }

    public Condition highStrengthCipherKey(@NonNls String algorithm) {
        return new CipherKeyHighStrengthCondition(this.eventBus, this.crypto, algorithm);
    }

    public Condition unlimitedStrengthCipherKey(@NonNls String algorithm) {
        return new CipherKeyUnlimitedStrengthCondition(this.eventBus, this.crypto, algorithm);
    }
}

