/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.support.condition;

import com.google.common.base.Preconditions;
import javax.inject.Provider;
import org.sonatype.nexus.plugins.capabilities.Condition;
import org.sonatype.nexus.plugins.capabilities.ConditionEvent;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.eventbus.EventBus;

public abstract class ConditionSupport
extends ComponentSupport
implements Condition {
    private final Provider<EventBus> eventBusProvider;
    private boolean satisfied;
    private boolean active;

    protected ConditionSupport(EventBus eventBus) {
        this(eventBus, false);
    }

    protected ConditionSupport(final EventBus eventBus, boolean satisfied) {
        this(new Provider<EventBus>(){

            public EventBus get() {
                return eventBus;
            }
        }, satisfied);
    }

    protected ConditionSupport(Provider<EventBus> eventBusProvider) {
        this(eventBusProvider, false);
    }

    protected ConditionSupport(Provider<EventBus> eventBusProvider, boolean satisfied) {
        this.eventBusProvider = (Provider)Preconditions.checkNotNull(eventBusProvider);
        this.satisfied = satisfied;
        this.active = false;
    }

    public EventBus getEventBus() {
        return (EventBus)this.eventBusProvider.get();
    }

    @Override
    public boolean isSatisfied() {
        return this.satisfied;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public final Condition bind() {
        if (!this.active) {
            this.active = true;
            this.doBind();
        }
        return this;
    }

    @Override
    public final Condition release() {
        if (this.active) {
            this.doRelease();
            this.active = false;
        }
        return this;
    }

    @Override
    public String explainSatisfied() {
        return this + " is satisfied";
    }

    @Override
    public String explainUnsatisfied() {
        return this + " is not satisfied";
    }

    protected abstract void doBind();

    protected abstract void doRelease();

    protected void setSatisfied(boolean satisfied) {
        if (this.satisfied != satisfied) {
            this.satisfied = satisfied;
            if (this.active) {
                if (this.satisfied) {
                    this.getEventBus().post((Object)new ConditionEvent.Satisfied(this));
                } else {
                    this.getEventBus().post((Object)new ConditionEvent.Unsatisfied(this));
                }
            }
        }
    }
}

