/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.support.condition;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.plugins.capabilities.CapabilityDescriptorRegistry;
import org.sonatype.nexus.plugins.capabilities.CapabilityRegistry;
import org.sonatype.nexus.plugins.capabilities.CapabilityType;
import org.sonatype.nexus.plugins.capabilities.Condition;
import org.sonatype.nexus.plugins.capabilities.Evaluable;
import org.sonatype.nexus.plugins.capabilities.internal.condition.CapabilityHasNoFailures;
import org.sonatype.nexus.plugins.capabilities.internal.condition.CapabilityOfTypeActiveCondition;
import org.sonatype.nexus.plugins.capabilities.internal.condition.CapabilityOfTypeExistsCondition;
import org.sonatype.nexus.plugins.capabilities.internal.condition.EvaluableCondition;
import org.sonatype.nexus.plugins.capabilities.internal.condition.PassivateCapabilityDuringUpdateCondition;
import org.sonatype.sisu.goodies.eventbus.EventBus;

@Named
@Singleton
public class CapabilityConditions {
    private final CapabilityRegistry capabilityRegistry;
    private final EventBus eventBus;
    private final CapabilityDescriptorRegistry descriptorRegistry;

    @Inject
    public CapabilityConditions(EventBus eventBus, CapabilityDescriptorRegistry descriptorRegistry, CapabilityRegistry capabilityRegistry) {
        this.descriptorRegistry = (CapabilityDescriptorRegistry)Preconditions.checkNotNull((Object)descriptorRegistry);
        this.capabilityRegistry = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry);
        this.eventBus = (EventBus)Preconditions.checkNotNull((Object)eventBus);
    }

    public Condition capabilityOfTypeExists(CapabilityType type) {
        return new CapabilityOfTypeExistsCondition(this.eventBus, this.descriptorRegistry, this.capabilityRegistry, type);
    }

    public Condition capabilityOfTypeActive(CapabilityType type) {
        return new CapabilityOfTypeActiveCondition(this.eventBus, this.descriptorRegistry, this.capabilityRegistry, type);
    }

    public Condition passivateCapabilityDuringUpdate() {
        return new PassivateCapabilityDuringUpdateCondition(this.eventBus, new String[0]);
    }

    public Condition passivateCapabilityWhenPropertyChanged(String ... propertyNames) {
        return new PassivateCapabilityDuringUpdateCondition(this.eventBus, propertyNames);
    }

    public Condition capabilityHasNoFailures() {
        return new CapabilityHasNoFailures(this.eventBus);
    }

    public Condition evaluable(Evaluable condition) {
        return new EvaluableCondition(this.eventBus, condition);
    }
}

