/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.support;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.plugins.capabilities.CapabilityReference;
import org.sonatype.nexus.plugins.capabilities.CapabilityRegistry;
import org.sonatype.nexus.plugins.capabilities.CapabilityRegistryEvent;
import org.sonatype.nexus.plugins.capabilities.CapabilityType;
import org.sonatype.nexus.plugins.capabilities.support.CapabilityReferenceFilterBuilder;
import org.sonatype.sisu.goodies.eventbus.EventBus;

public abstract class CapabilityBooterSupport {
    private static final Logger log = LoggerFactory.getLogger(CapabilityBooterSupport.class);

    @Inject
    public void installEventBus(final EventBus eventBus) {
        ((EventBus)Preconditions.checkNotNull((Object)eventBus)).register(new Object(){

            @Subscribe
            public void handle(CapabilityRegistryEvent.AfterLoad event) {
                eventBus.unregister((Object)this);
                CapabilityRegistry registry = (CapabilityRegistry)event.getEventSender();
                try {
                    CapabilityBooterSupport.this.boot(registry);
                }
                catch (Exception e) {
                    throw Throwables.propagate((Throwable)e);
                }
            }
        });
    }

    protected abstract void boot(CapabilityRegistry var1) throws Exception;

    protected void maybeAddCapability(CapabilityRegistry capabilityRegistry, CapabilityType type, boolean enabled, String notes, Map<String, String> properties) throws Exception {
        CapabilityReference reference = this.findCapability(capabilityRegistry, type);
        if (reference == null) {
            log.debug("Automatically adding capability type: {}; enabled: {}", (Object)type, (Object)enabled);
            this.addCapability(capabilityRegistry, type, enabled, notes, properties);
        }
    }

    protected CapabilityReference findCapability(CapabilityRegistry capabilityRegistry, CapabilityType type) {
        return this.findCapability(capabilityRegistry, type, true);
    }

    protected CapabilityReference findCapability(CapabilityRegistry capabilityRegistry, CapabilityType type, boolean includeNotExposed) {
        Collection<? extends CapabilityReference> capabilities;
        CapabilityReferenceFilterBuilder.CapabilityReferenceFilter filter = CapabilityReferenceFilterBuilder.capabilities().withType(type);
        if (includeNotExposed) {
            filter.includeNotExposed();
        }
        if ((capabilities = capabilityRegistry.get(filter)) != null && !capabilities.isEmpty()) {
            return capabilities.iterator().next();
        }
        return null;
    }

    protected void addCapability(CapabilityRegistry capabilityRegistry, CapabilityType type, boolean enabled, String notes, Map<String, String> properties) throws Exception {
        capabilityRegistry.add(type, enabled, notes == null ? "Automatically added on " + new Date() : notes, properties);
    }
}

