/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.validator;

import com.google.common.base.Preconditions;
import com.google.inject.assistedinject.Assisted;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.capability.support.ValidatorSupport;
import org.sonatype.nexus.plugins.capabilities.CapabilityDescriptorRegistry;
import org.sonatype.nexus.plugins.capabilities.CapabilityType;
import org.sonatype.nexus.plugins.capabilities.ValidationResult;
import org.sonatype.nexus.plugins.capabilities.Validator;
import org.sonatype.nexus.plugins.capabilities.support.validator.DefaultValidationResult;
import org.sonatype.sisu.goodies.i18n.I18N;
import org.sonatype.sisu.goodies.i18n.MessageBundle;

public class UrlValidator
extends ValidatorSupport
implements Validator {
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final String key;
    private final String label;

    @Inject
    public UrlValidator(Provider<CapabilityDescriptorRegistry> capabilityDescriptorRegistryProvider, @Assisted CapabilityType type, @Assisted String key) {
        super(capabilityDescriptorRegistryProvider, type);
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.label = this.propertyName(key);
    }

    @Override
    public ValidationResult validate(Map<String, String> properties) {
        String value = properties.get(this.key);
        if (StringUtils.isNotEmpty((String)value)) {
            try {
                new URL(value);
            }
            catch (MalformedURLException e) {
                return new DefaultValidationResult().add(this.key, messages.invalidReason(this.label, e.getMessage()));
            }
        }
        return ValidationResult.VALID;
    }

    @Override
    public String explainValid() {
        return messages.valid(this.label);
    }

    @Override
    public String explainInvalid() {
        return messages.invalid(this.label);
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="%s is a valid URL")
        public String valid(String var1);

        @MessageBundle.DefaultMessage(value="%s is not a valid URL")
        public String invalid(String var1);

        @MessageBundle.DefaultMessage(value="%s is not a valid URL (%s)")
        public String invalidReason(String var1, String var2);
    }
}

