/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.validator;

import com.google.common.base.Preconditions;
import com.google.inject.assistedinject.Assisted;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.sonatype.nexus.capability.support.ValidatorSupport;
import org.sonatype.nexus.plugins.capabilities.CapabilityDescriptorRegistry;
import org.sonatype.nexus.plugins.capabilities.CapabilityType;
import org.sonatype.nexus.plugins.capabilities.ValidationResult;
import org.sonatype.nexus.plugins.capabilities.Validator;
import org.sonatype.nexus.plugins.capabilities.support.validator.DefaultValidationResult;

@Named
public class RequiredFieldValidator
extends ValidatorSupport
implements Validator {
    private final String key;
    private final String label;

    @Inject
    RequiredFieldValidator(Provider<CapabilityDescriptorRegistry> capabilityDescriptorRegistryProvider, @Assisted CapabilityType type, @Assisted String key) {
        super(capabilityDescriptorRegistryProvider, type);
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.label = this.propertyName(key);
    }

    @Override
    public ValidationResult validate(Map<String, String> properties) {
        String value;
        if (properties != null && ((value = properties.get(this.key)) == null || value.trim().length() == 0)) {
            return new DefaultValidationResult().add(this.key, String.valueOf(this.label) + " is required");
        }
        return ValidationResult.VALID;
    }

    @Override
    public String explainValid() {
        return String.valueOf(this.label) + " is not null or empty";
    }

    @Override
    public String explainInvalid() {
        return String.valueOf(this.label) + " is null or empty";
    }
}

