/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.validator;

import com.google.common.base.Preconditions;
import com.google.inject.assistedinject.Assisted;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.sonatype.nexus.capability.support.ValidatorSupport;
import org.sonatype.nexus.plugins.capabilities.CapabilityDescriptorRegistry;
import org.sonatype.nexus.plugins.capabilities.CapabilityType;
import org.sonatype.nexus.plugins.capabilities.ValidationResult;
import org.sonatype.nexus.plugins.capabilities.Validator;
import org.sonatype.nexus.plugins.capabilities.support.validator.DefaultValidationResult;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.Repository;

@Named
public class RepositoryTypeValidator
extends ValidatorSupport
implements Validator {
    private final RepositoryRegistry repositoryRegistry;
    private final String propertyKey;
    private final Class<?> facet;

    @Inject
    RepositoryTypeValidator(RepositoryRegistry repositoryRegistry, Provider<CapabilityDescriptorRegistry> capabilityDescriptorRegistryProvider, @Assisted CapabilityType type, @Assisted String propertyKey, @Assisted Class<?> facet) {
        super(capabilityDescriptorRegistryProvider, type);
        this.repositoryRegistry = (RepositoryRegistry)Preconditions.checkNotNull((Object)repositoryRegistry);
        this.propertyKey = (String)Preconditions.checkNotNull((Object)propertyKey);
        this.facet = (Class)Preconditions.checkNotNull(facet);
    }

    @Override
    public ValidationResult validate(Map<String, String> properties) {
        String repositoryId = properties.get(this.propertyKey);
        if (repositoryId != null) {
            try {
                Repository repository = this.repositoryRegistry.getRepository(repositoryId);
                if (!repository.getRepositoryKind().isFacetAvailable(this.facet)) {
                    return new DefaultValidationResult().add(this.propertyKey, this.buildMessage(repository));
                }
            }
            catch (NoSuchRepositoryException noSuchRepositoryException) {}
        }
        return ValidationResult.VALID;
    }

    @Override
    public String explainValid() {
        StringBuilder message = new StringBuilder();
        message.append(this.propertyName(this.propertyKey)).append(" is a ").append(this.facetName()).append(" repository");
        return message.toString();
    }

    @Override
    public String explainInvalid() {
        StringBuilder message = new StringBuilder();
        message.append(this.propertyName(this.propertyKey)).append(" is not a ").append(this.facetName()).append(" repository");
        return message.toString();
    }

    private String buildMessage(Repository repository) {
        StringBuilder message = new StringBuilder();
        message.append("Selected ").append(this.propertyName(this.propertyKey).toLowerCase()).append(" '").append(repository.getName()).append("' must be a ").append(this.facetName()).append(" repository");
        return message.toString();
    }

    private Object facetName() {
        return this.facet.getSimpleName().toLowerCase().replace("repository", "");
    }
}

