/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.validator;

import com.google.common.base.Preconditions;
import com.google.inject.assistedinject.Assisted;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.sonatype.nexus.capability.support.ValidatorSupport;
import org.sonatype.nexus.plugins.capabilities.CapabilityDescriptorRegistry;
import org.sonatype.nexus.plugins.capabilities.CapabilityType;
import org.sonatype.nexus.plugins.capabilities.ValidationResult;
import org.sonatype.nexus.plugins.capabilities.Validator;
import org.sonatype.nexus.plugins.capabilities.support.validator.DefaultValidationResult;
import org.sonatype.nexus.proxy.NoSuchRepositoryException;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;

@Named
public class RepositoryExistsValidator
extends ValidatorSupport
implements Validator {
    private final RepositoryRegistry repositoryRegistry;
    private final String propertyKey;

    @Inject
    RepositoryExistsValidator(RepositoryRegistry repositoryRegistry, Provider<CapabilityDescriptorRegistry> capabilityDescriptorRegistryProvider, @Assisted CapabilityType type, @Assisted String propertyKey) {
        super(capabilityDescriptorRegistryProvider, type);
        this.repositoryRegistry = (RepositoryRegistry)Preconditions.checkNotNull((Object)repositoryRegistry);
        this.propertyKey = (String)Preconditions.checkNotNull((Object)propertyKey);
    }

    @Override
    public ValidationResult validate(Map<String, String> properties) {
        String repositoryId = properties.get(this.propertyKey);
        if (repositoryId != null) {
            try {
                this.repositoryRegistry.getRepository(repositoryId);
            }
            catch (NoSuchRepositoryException noSuchRepositoryException) {
                return new DefaultValidationResult().add(this.propertyKey, this.buildMessage(repositoryId));
            }
        }
        return ValidationResult.VALID;
    }

    @Override
    public String explainValid() {
        StringBuilder message = new StringBuilder();
        message.append(this.propertyName(this.propertyKey)).append(" exists");
        return message.toString();
    }

    @Override
    public String explainInvalid() {
        StringBuilder message = new StringBuilder();
        message.append(this.propertyName(this.propertyKey)).append(" does not exist");
        return message.toString();
    }

    private String buildMessage(String repositoryId) {
        StringBuilder message = new StringBuilder();
        message.append("Selected ").append(this.propertyName(this.propertyKey).toLowerCase()).append(" '").append(repositoryId).append("' could not be found");
        return message.toString();
    }
}

