/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.validator;

import com.google.common.base.Preconditions;
import com.google.inject.assistedinject.Assisted;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.sonatype.nexus.capability.support.ValidatorSupport;
import org.sonatype.nexus.plugins.capabilities.CapabilityDescriptorRegistry;
import org.sonatype.nexus.plugins.capabilities.CapabilityType;
import org.sonatype.nexus.plugins.capabilities.ValidationResult;
import org.sonatype.nexus.plugins.capabilities.Validator;
import org.sonatype.nexus.plugins.capabilities.support.validator.DefaultValidationResult;

@Named
public class RegexpFieldValidator
extends ValidatorSupport
implements Validator {
    private final String key;
    private final Pattern pattern;
    private final String label;

    @Inject
    RegexpFieldValidator(Provider<CapabilityDescriptorRegistry> capabilityDescriptorRegistryProvider, @Assisted CapabilityType type, @Assisted(value="key") String key, @Assisted(value="regexp") String regexp) {
        super(capabilityDescriptorRegistryProvider, type);
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.pattern = Pattern.compile((String)Preconditions.checkNotNull((Object)regexp));
        this.label = this.propertyName(key);
    }

    @Override
    public ValidationResult validate(Map<String, String> properties) {
        String value;
        if (properties != null && (value = properties.get(this.key)) != null && !this.pattern.matcher(value).matches()) {
            return new DefaultValidationResult().add(this.key, String.valueOf(this.label) + " does not match '" + this.pattern.pattern() + "'");
        }
        return ValidationResult.VALID;
    }

    @Override
    public String explainValid() {
        return String.valueOf(this.label) + " matches '" + this.pattern.pattern() + "'";
    }

    @Override
    public String explainInvalid() {
        return String.valueOf(this.label) + " does not match '" + this.pattern.pattern() + "'";
    }
}

