/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.validator;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.inject.assistedinject.Assisted;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.sonatype.nexus.capability.support.ValidatorSupport;
import org.sonatype.nexus.plugins.capabilities.CapabilityDescriptorRegistry;
import org.sonatype.nexus.plugins.capabilities.CapabilityIdentity;
import org.sonatype.nexus.plugins.capabilities.CapabilityReference;
import org.sonatype.nexus.plugins.capabilities.CapabilityRegistry;
import org.sonatype.nexus.plugins.capabilities.CapabilityType;
import org.sonatype.nexus.plugins.capabilities.ValidationResult;
import org.sonatype.nexus.plugins.capabilities.Validator;
import org.sonatype.nexus.plugins.capabilities.support.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.plugins.capabilities.support.validator.DefaultValidationResult;

@Named
public class PrimaryKeyValidator
extends ValidatorSupport
implements Validator {
    private final CapabilityRegistry capabilityRegistry;
    private final CapabilityIdentity excludeId;
    private final String[] propertyKeys;

    @Inject
    PrimaryKeyValidator(CapabilityRegistry capabilityRegistry, Provider<CapabilityDescriptorRegistry> capabilityDescriptorRegistryProvider, @Assisted CapabilityType type, String ... propertyKeys) {
        super(capabilityDescriptorRegistryProvider, type);
        this.capabilityRegistry = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry);
        this.excludeId = null;
        this.propertyKeys = propertyKeys;
    }

    PrimaryKeyValidator(CapabilityRegistry capabilityRegistry, Provider<CapabilityDescriptorRegistry> capabilityDescriptorRegistryProvider, CapabilityIdentity excludeId, CapabilityType type, String ... propertyKeys) {
        super(capabilityDescriptorRegistryProvider, type);
        this.capabilityRegistry = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry);
        this.excludeId = (CapabilityIdentity)Preconditions.checkNotNull((Object)excludeId);
        this.propertyKeys = propertyKeys;
    }

    @Override
    public ValidationResult validate(Map<String, String> properties) {
        Collection<? extends CapabilityReference> references = this.capabilityRegistry.get(this.buildFilter(properties));
        if (references == null || references.isEmpty() || references.size() == 1 && references.iterator().next().context().id().equals(this.excludeId)) {
            return ValidationResult.VALID;
        }
        return new DefaultValidationResult().add(this.buildMessage(properties));
    }

    @Override
    public String explainValid() {
        StringBuilder message = new StringBuilder().append("Only one capability with type '").append(this.typeName()).append("'");
        if (this.propertyKeys != null) {
            String[] stringArray = this.propertyKeys;
            int n = this.propertyKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                message.append(", same ").append(this.propertyName(key).toLowerCase());
                ++n2;
            }
        }
        message.append(" exists");
        return message.toString();
    }

    @Override
    public String explainInvalid() {
        StringBuilder message = new StringBuilder().append("More then one capability with type '").append(this.typeName()).append("'");
        if (this.propertyKeys != null) {
            String[] stringArray = this.propertyKeys;
            int n = this.propertyKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                message.append(", same ").append(this.propertyName(key).toLowerCase());
                ++n2;
            }
        }
        message.append(" exists");
        return message.toString();
    }

    private String buildMessage(Map<String, String> properties) {
        StringBuilder message = new StringBuilder().append("Only one capability of type '").append(this.typeName()).append("'");
        if (properties != null) {
            String[] stringArray = this.propertyKeys;
            int n = this.propertyKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                message.append(", ").append(this.propertyName(key).toLowerCase()).append(" '").append(properties.get(key)).append("'");
                ++n2;
            }
        }
        message.append(" can be created");
        return message.toString();
    }

    private Predicate<CapabilityReference> buildFilter(Map<String, String> properties) {
        CapabilityReferenceFilterBuilder.CapabilityReferenceFilter filter = CapabilityReferenceFilterBuilder.capabilities().withType(this.capabilityType());
        if (this.propertyKeys != null) {
            String[] stringArray = this.propertyKeys;
            int n = this.propertyKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                filter.withProperty(key, properties.get(key));
                ++n2;
            }
        }
        return filter;
    }
}

