/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.validator;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import org.sonatype.nexus.plugins.capabilities.ValidationResult;
import org.sonatype.nexus.plugins.capabilities.Validator;
import org.sonatype.nexus.plugins.capabilities.support.validator.DefaultValidationResult;

public class DisjunctionValidator
implements Validator {
    private final Validator[] validators;

    @Inject
    public DisjunctionValidator(Validator ... validators) {
        this.validators = (Validator[])Preconditions.checkNotNull((Object)validators);
        Preconditions.checkArgument((validators.length > 0 ? 1 : 0) != 0, (Object)"There must be at least one validator");
        Validator[] validatorArray = validators;
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            Validator validator = validatorArray[n2];
            Preconditions.checkNotNull((Object)validator);
            ++n2;
        }
    }

    @Override
    public ValidationResult validate(Map<String, String> properties) {
        DefaultValidationResult failed = new DefaultValidationResult();
        Validator[] validatorArray = this.validators;
        int n = this.validators.length;
        int n2 = 0;
        while (n2 < n) {
            Validator validator = validatorArray[n2];
            ValidationResult validationResult = validator.validate(properties);
            if (validationResult.isValid()) {
                return ValidationResult.VALID;
            }
            failed.add(validationResult.violations());
            ++n2;
        }
        return failed;
    }

    @Override
    public String explainValid() {
        StringBuilder sb = new StringBuilder();
        sb.append("One of following is valid: ");
        Validator[] validatorArray = this.validators;
        int n = this.validators.length;
        int n2 = 0;
        while (n2 < n) {
            Validator validator = validatorArray[n2];
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append(validator.explainValid());
            ++n2;
        }
        return sb.toString();
    }

    @Override
    public String explainInvalid() {
        StringBuilder sb = new StringBuilder();
        sb.append("All of following is invalid: ");
        Validator[] validatorArray = this.validators;
        int n = this.validators.length;
        int n2 = 0;
        while (n2 < n) {
            Validator validator = validatorArray[n2];
            if (sb.length() > 0) {
                sb.append(" AND ");
            }
            sb.append(validator.explainValid());
            ++n2;
        }
        return sb.toString();
    }
}

