/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.validator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.inject.assistedinject.Assisted;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.sonatype.nexus.capability.support.ValidatorSupport;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.plugins.capabilities.CapabilityDescriptorRegistry;
import org.sonatype.nexus.plugins.capabilities.CapabilityType;
import org.sonatype.nexus.plugins.capabilities.ValidationResult;
import org.sonatype.nexus.plugins.capabilities.Validator;
import org.sonatype.nexus.plugins.capabilities.support.validator.Validators;

@Named
public class DescriptorConstraintsValidator
extends ValidatorSupport
implements Validator {
    private final Validator validator;

    @Inject
    DescriptorConstraintsValidator(Validators validators, Provider<CapabilityDescriptorRegistry> capabilityDescriptorRegistryProvider, @Assisted CapabilityType type) {
        super(capabilityDescriptorRegistryProvider, type);
        Preconditions.checkNotNull((Object)validators);
        Validator descriptorValidator = validators.capability().alwaysValid();
        List<FormField> formFields = this.capabilityDescriptor().formFields();
        if (formFields != null) {
            ArrayList fieldValidators = Lists.newArrayList();
            for (FormField formField : formFields) {
                String regexp;
                if (formField.isRequired()) {
                    fieldValidators.add(validators.capability().required(type, formField.getId()));
                }
                if ((regexp = formField.getRegexValidation()) == null || regexp.trim().length() <= 0) continue;
                fieldValidators.add(validators.capability().matches(type, formField.getId(), regexp));
            }
            if (!fieldValidators.isEmpty()) {
                descriptorValidator = validators.logical().and(fieldValidators.toArray(new Validator[fieldValidators.size()]));
            }
        }
        this.validator = descriptorValidator;
    }

    @Override
    public ValidationResult validate(Map<String, String> properties) {
        return this.validator.validate(properties);
    }

    @Override
    public String explainValid() {
        return this.validator.explainValid();
    }

    @Override
    public String explainInvalid() {
        return this.validator.explainInvalid();
    }
}

