/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.storage;

import com.google.common.collect.Maps;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.sonatype.nexus.configuration.application.ApplicationConfiguration;
import org.sonatype.nexus.plugins.capabilities.CapabilityIdentity;
import org.sonatype.nexus.plugins.capabilities.internal.config.persistence.CCapability;
import org.sonatype.nexus.plugins.capabilities.internal.config.persistence.CCapabilityProperty;
import org.sonatype.nexus.plugins.capabilities.internal.config.persistence.Configuration;
import org.sonatype.nexus.plugins.capabilities.internal.config.persistence.io.xpp3.NexusCapabilitiesConfigurationXpp3Reader;
import org.sonatype.nexus.plugins.capabilities.internal.config.persistence.io.xpp3.NexusCapabilitiesConfigurationXpp3Writer;
import org.sonatype.nexus.plugins.capabilities.internal.storage.CapabilityStorage;
import org.sonatype.nexus.plugins.capabilities.internal.storage.CapabilityStorageItem;
import org.sonatype.nexus.util.Tokens;
import org.sonatype.sisu.goodies.common.io.FileReplacer;
import org.sonatype.sisu.goodies.lifecycle.LifecycleSupport;

@Named(value="xml")
@Singleton
public class XmlCapabilityStorage
extends LifecycleSupport
implements CapabilityStorage {
    private final File configurationFile;
    private final ReentrantLock lock = new ReentrantLock();
    private Configuration configuration;
    private final AtomicLong identityCounter = new AtomicLong(System.nanoTime());

    @Inject
    public XmlCapabilityStorage(ApplicationConfiguration applicationConfiguration) {
        this.configurationFile = new File(applicationConfiguration.getConfigurationDirectory(), "capabilities.xml");
    }

    public File getConfigurationFile() {
        return this.configurationFile;
    }

    private CapabilityIdentity generateIdentity() {
        long id = this.identityCounter.incrementAndGet();
        byte[] bytes = ByteBuffer.allocate(8).putLong(id).array();
        return new CapabilityIdentity(Tokens.encodeHexString((byte[])bytes));
    }

    @Override
    public CapabilityIdentity add(CapabilityStorageItem item) throws IOException {
        try {
            this.lock.lock();
            CapabilityIdentity identity = this.generateIdentity();
            this.load().addCapability(this.convert(identity, item));
            this.save();
            CapabilityIdentity capabilityIdentity = identity;
            return capabilityIdentity;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean update(CapabilityIdentity identity, CapabilityStorageItem item) throws IOException {
        try {
            this.lock.lock();
            CCapability capability = this.convert(identity, item);
            CCapability stored = this.getInternal(capability.getId());
            if (stored == null) {
                return false;
            }
            this.load().removeCapability(stored);
            this.load().addCapability(capability);
            this.save();
            return true;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean remove(CapabilityIdentity id) throws IOException {
        try {
            this.lock.lock();
            CCapability stored = this.getInternal(id.toString());
            if (stored == null) {
                return false;
            }
            this.load().removeCapability(stored);
            this.save();
            return true;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Map<CapabilityIdentity, CapabilityStorageItem> getAll() throws IOException {
        HashMap entries = Maps.newHashMap();
        List<CCapability> capabilities = this.load().getCapabilities();
        if (capabilities != null) {
            for (CCapability element : capabilities) {
                CapabilityIdentity identity = new CapabilityIdentity(element.getId());
                entries.put(identity, this.convert(element));
            }
        }
        return entries;
    }

    /*
     * Loose catch block
     */
    private Configuration load() throws IOException {
        block10: {
            if (this.configuration != null) {
                return this.configuration;
            }
            this.lock.lock();
            InputStreamReader fr = null;
            FileInputStream is = null;
            try {
                FileReader r = new FileReader(this.configurationFile);
                Xpp3DomBuilder.build((Reader)r);
                is = new FileInputStream(this.configurationFile);
                NexusCapabilitiesConfigurationXpp3Reader reader = new NexusCapabilitiesConfigurationXpp3Reader();
                fr = new InputStreamReader(is);
                this.configuration = reader.read(fr);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.configuration = new Configuration();
                this.configuration.setVersion("2.0.0");
                this.save();
                IOUtil.close(fr);
                IOUtil.close((InputStream)is);
                this.lock.unlock();
                break block10;
            }
            catch (IOException e) {
                this.log.error("IOException while retrieving configuration file", (Throwable)e);
                break block10;
            }
            catch (XmlPullParserException e) {
                this.log.error("Invalid XML Configuration", (Throwable)e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                IOUtil.close(fr);
                IOUtil.close(is);
                this.lock.unlock();
                break block10;
            }
            {
                finally {
                    IOUtil.close(fr);
                    IOUtil.close(is);
                    this.lock.unlock();
                }
            }
            IOUtil.close((Reader)fr);
            IOUtil.close((InputStream)is);
            this.lock.unlock();
        }
        return this.configuration;
    }

    private void save() throws IOException {
        this.lock.lock();
        this.log.debug("Saving configuration: {}", (Object)this.configurationFile);
        try {
            FileReplacer fileReplacer = new FileReplacer(this.configurationFile);
            fileReplacer.setDeleteBackupFile(true);
            fileReplacer.replace(new FileReplacer.ContentWriter(){

                public void write(BufferedOutputStream output) throws IOException {
                    new NexusCapabilitiesConfigurationXpp3Writer().write(output, XmlCapabilityStorage.this.configuration);
                }
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    private CCapability getInternal(String capabilityId) throws IOException {
        if (StringUtils.isEmpty((String)capabilityId)) {
            return null;
        }
        for (CCapability element : this.load().getCapabilities()) {
            if (!capabilityId.equals(element.getId())) continue;
            return element;
        }
        return null;
    }

    private CapabilityStorageItem convert(CCapability element) {
        HashMap properties = Maps.newHashMap();
        if (element.getProperties() != null) {
            for (CCapabilityProperty property : element.getProperties()) {
                properties.put(property.getKey(), property.getValue());
            }
        }
        return new CapabilityStorageItem(element.getVersion(), element.getTypeId(), element.isEnabled(), element.getNotes(), properties);
    }

    private CCapability convert(CapabilityIdentity identity, CapabilityStorageItem item) {
        CCapability element = new CCapability();
        element.setId(identity.toString());
        element.setVersion(item.getVersion());
        element.setTypeId(item.getType());
        element.setEnabled(item.isEnabled());
        element.setNotes(item.getNotes());
        if (item.getProperties() != null) {
            for (Map.Entry<String, String> entry : item.getProperties().entrySet()) {
                CCapabilityProperty property = new CCapabilityProperty();
                property.setKey(entry.getKey());
                property.setValue(entry.getValue());
                element.addProperty(property);
            }
        }
        return element;
    }
}

