/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.storage;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.plugins.capabilities.internal.storage.CapabilityStorage;
import org.sonatype.nexus.plugins.capabilities.internal.storage.CapabilityStorageItem;
import org.sonatype.nexus.plugins.capabilities.internal.storage.KazukiCapabilityStorage;
import org.sonatype.sisu.goodies.common.ComponentSupport;

@Named
@Singleton
public class KazukiCapabilityStorageConverter
extends ComponentSupport {
    private final KazukiCapabilityStorage kazukiCapabilityStorage;
    private final CapabilityStorage capabilityStorage;

    @Inject
    public KazukiCapabilityStorageConverter(KazukiCapabilityStorage kazukiCapabilityStorage, CapabilityStorage capabilityStorage) {
        this.kazukiCapabilityStorage = (KazukiCapabilityStorage)Preconditions.checkNotNull((Object)kazukiCapabilityStorage);
        this.capabilityStorage = (CapabilityStorage)Preconditions.checkNotNull((Object)capabilityStorage);
    }

    public void maybeConvert() throws Exception {
        if (this.kazukiCapabilityStorage.exists()) {
            this.log.info("Converting KZ-based storage to default implementation");
            this.kazukiCapabilityStorage.start();
            int count = 0;
            for (CapabilityStorageItem item : this.kazukiCapabilityStorage.getAll().values()) {
                this.capabilityStorage.add(item);
                ++count;
            }
            this.log.info("Converted {} capability entities", (Object)count);
            this.kazukiCapabilityStorage.stop();
            this.kazukiCapabilityStorage.drop();
            this.log.info("Dropped KZ-based storage");
        }
    }
}

