/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.storage;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.kazuki.v0.internal.v2schema.Attribute;
import io.kazuki.v0.internal.v2schema.Schema;
import io.kazuki.v0.store.KazukiException;
import io.kazuki.v0.store.Key;
import io.kazuki.v0.store.keyvalue.KeyValueIterable;
import io.kazuki.v0.store.keyvalue.KeyValuePair;
import io.kazuki.v0.store.keyvalue.KeyValueStore;
import io.kazuki.v0.store.lifecycle.Lifecycle;
import io.kazuki.v0.store.schema.SchemaStore;
import io.kazuki.v0.store.schema.TypeValidation;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.configuration.application.ApplicationDirectories;
import org.sonatype.nexus.plugins.capabilities.CapabilityIdentity;
import org.sonatype.nexus.plugins.capabilities.internal.storage.CapabilityStorage;
import org.sonatype.nexus.plugins.capabilities.internal.storage.CapabilityStorageItem;
import org.sonatype.nexus.util.file.DirSupport;
import org.sonatype.sisu.goodies.lifecycle.LifecycleSupport;

@Named(value="kazuki")
@Singleton
public class KazukiCapabilityStorage
extends LifecycleSupport
implements CapabilityStorage {
    public static final String CAPABILITY_SCHEMA = "capability";
    private final ApplicationDirectories applicationDirectories;
    private final Lifecycle lifecycle;
    private final KeyValueStore keyValueStore;
    private final SchemaStore schemaStore;

    @Inject
    public KazukiCapabilityStorage(ApplicationDirectories applicationDirectories, @Named(value="nexuscapability") Lifecycle lifecycle, @Named(value="nexuscapability") KeyValueStore keyValueStore, @Named(value="nexuscapability") SchemaStore schemaStore) {
        this.applicationDirectories = (ApplicationDirectories)Preconditions.checkNotNull((Object)applicationDirectories);
        this.lifecycle = (Lifecycle)Preconditions.checkNotNull((Object)lifecycle);
        this.keyValueStore = (KeyValueStore)Preconditions.checkNotNull((Object)keyValueStore);
        this.schemaStore = (SchemaStore)Preconditions.checkNotNull((Object)schemaStore);
    }

    public boolean exists() {
        File dir = this.applicationDirectories.getWorkDirectory("db/capabilities", false);
        File file = new File(dir, "capabilities.h2.db");
        return file.exists();
    }

    public void drop() {
        File dir = this.applicationDirectories.getWorkDirectory("db/capabilities", false);
        try {
            DirSupport.deleteIfExists((Path)dir.toPath());
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected void doStart() throws Exception {
        this.lifecycle.init();
        this.lifecycle.start();
        if (this.schemaStore.retrieveSchema(CAPABILITY_SCHEMA) == null) {
            Schema schema = new Schema((List)ImmutableList.of((Object)new Attribute("version", Attribute.Type.I32, null, Boolean.valueOf(false)), (Object)new Attribute("type", Attribute.Type.UTF8_SMALLSTRING, null, Boolean.valueOf(true)), (Object)new Attribute("enabled", Attribute.Type.BOOLEAN, null, Boolean.valueOf(true)), (Object)new Attribute("notes", Attribute.Type.UTF8_TEXT, null, Boolean.valueOf(true)), (Object)new Attribute("properties", Attribute.Type.MAP, null, Boolean.valueOf(true))));
            this.log.info("Creating schema for 'capability' type");
            this.schemaStore.createSchema(CAPABILITY_SCHEMA, schema);
        }
    }

    protected void doStop() throws Exception {
        this.lifecycle.stop();
        this.lifecycle.shutdown();
    }

    @Override
    public CapabilityIdentity add(CapabilityStorageItem item) throws IOException {
        try {
            return this.asCapabilityIdentity(this.keyValueStore.create(CAPABILITY_SCHEMA, CapabilityStorageItem.class, (Object)item, TypeValidation.STRICT));
        }
        catch (KazukiException e) {
            throw new IOException("Capability could not be added", e);
        }
    }

    @Override
    public boolean update(CapabilityIdentity id, CapabilityStorageItem item) throws IOException {
        try {
            return this.keyValueStore.update(this.asKey(id), CapabilityStorageItem.class, (Object)item);
        }
        catch (KazukiException e) {
            throw new IOException("Capability could not be updated", e);
        }
    }

    @Override
    public boolean remove(CapabilityIdentity id) throws IOException {
        try {
            return this.keyValueStore.delete(this.asKey(id));
        }
        catch (KazukiException e) {
            throw new IOException("Capability could not be removed", e);
        }
    }

    @Override
    public Map<CapabilityIdentity, CapabilityStorageItem> getAll() throws IOException {
        HashMap items = Maps.newHashMap();
        Throwable throwable = null;
        Object var3_4 = null;
        try (KeyValueIterable entries = this.keyValueStore.iterators().entries(CAPABILITY_SCHEMA, CapabilityStorageItem.class);){
            for (KeyValuePair entry : entries) {
                items.put(this.asCapabilityIdentity(entry.getKey()), (CapabilityStorageItem)entry.getValue());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return items;
    }

    private Key asKey(CapabilityIdentity id) {
        return this.keyValueStore.toKey("@capability:" + id.toString());
    }

    private CapabilityIdentity asCapabilityIdentity(Key key) {
        return new CapabilityIdentity(key.getIdPart());
    }
}

