/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.rest;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.nexus.capabilities.model.SelectableEntryXO;
import org.sonatype.nexus.capability.spi.SelectableEntryProvider;
import org.sonatype.nexus.proxy.access.NexusItemAuthorizer;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.Repository;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.goodies.i18n.I18N;
import org.sonatype.sisu.goodies.i18n.MessageBundle;
import org.sonatype.sisu.siesta.common.Resource;

@Named
@Singleton
@Path(value="/capabilities/stores")
public class StoresResource
extends ComponentSupport
implements Resource {
    public static final String RESOURCE_URI = "/capabilities/stores";
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final Map<String, SelectableEntryProvider> namedProviders;
    private final RepositoryRegistry repositoryRegistry;
    private final NexusItemAuthorizer nexusItemAuthorizer;

    @Inject
    public StoresResource(RepositoryRegistry repositoryRegistry, NexusItemAuthorizer nexusItemAuthorizer, Map<String, SelectableEntryProvider> namedProviders) {
        this.repositoryRegistry = (RepositoryRegistry)Preconditions.checkNotNull((Object)repositoryRegistry);
        this.nexusItemAuthorizer = (NexusItemAuthorizer)Preconditions.checkNotNull((Object)nexusItemAuthorizer);
        this.namedProviders = (Map)Preconditions.checkNotNull(namedProviders);
    }

    @GET
    @Path(value="/repositories")
    @Produces(value={"application/xml", "application/json"})
    @RequiresPermissions(value={"nexus:repositories:read"})
    public List<SelectableEntryXO> getRepositories(@QueryParam(value="allReposEntry") Boolean allReposEntry, @QueryParam(value="regardlessViewPermissions") Boolean regardlessViewPermissions, @QueryParam(value="facet") List<String> facets, @QueryParam(value="contentClass") List<String> contentClasses) {
        final Predicate predicate = Predicates.and(StoresResource.removeNulls(this.hasRightsToView(regardlessViewPermissions), this.hasAnyOfFacets(facets), this.hasNoneOfFacets(facets), this.hasAnyOfContentClasses(contentClasses), this.hasNoneOfContentClasses(contentClasses)));
        List entries = Lists.transform((List)Lists.newArrayList((Iterable)Iterables.filter((Iterable)this.repositoryRegistry.getRepositories(), (Predicate)new Predicate<Repository>(){

            public boolean apply(@Nullable Repository input) {
                return input != null && predicate.apply((Object)input);
            }
        })), (Function)new Function<Repository, SelectableEntryXO>(){

            public SelectableEntryXO apply(Repository input) {
                return new SelectableEntryXO().withId(input.getId()).withName(input.getName());
            }
        });
        if (allReposEntry != null && allReposEntry.booleanValue()) {
            entries = Lists.newArrayList((Iterable)entries);
            entries.add(0, new SelectableEntryXO().withId("*").withName(messages.allRepositoriesName()));
        }
        return entries;
    }

    @GET
    @Path(value="/provider/{name}")
    @Produces(value={"application/xml", "application/json"})
    public List<SelectableEntryXO> getFromProvider(@PathParam(value="name") String name, @Context UriInfo uriInfo) {
        SelectableEntryProvider provider = this.namedProviders.get(name);
        List<SelectableEntryXO> entries = null;
        if (provider == null) {
            this.log.warn("Could not find a {} bounded to name {}", (Object)SelectableEntryProvider.class.getName(), (Object)name);
        } else {
            try {
                entries = provider.get(this.asParameters((MultivaluedMap<String, String>)uriInfo.getQueryParameters()));
            }
            catch (Exception e) {
                this.log.warn("Provider {} failed to provide the list of entries due to {}/{}", new Object[]{provider, e.getClass().getName(), e.getMessage(), this.log.isDebugEnabled() ? e : null});
            }
        }
        if (entries == null) {
            return Lists.newArrayList();
        }
        return entries;
    }

    private SelectableEntryProvider.Parameters asParameters(final MultivaluedMap<String, String> queryParameters) {
        return new SelectableEntryProvider.Parameters(){

            @Override
            public String getFirst(String name) {
                return (String)queryParameters.getFirst((Object)name);
            }

            @Override
            public List<String> get(String name) {
                return (List)queryParameters.get((Object)name);
            }
        };
    }

    private Predicate<Repository> hasRightsToView(Boolean skipPermissions) {
        if (skipPermissions == null || !skipPermissions.booleanValue()) {
            return new Predicate<Repository>(){

                public boolean apply(@Nullable Repository input) {
                    return input != null && StoresResource.this.nexusItemAuthorizer.isViewable("repository", input.getId());
                }
            };
        }
        return null;
    }

    private Predicate<Repository> hasAnyOfFacets(@Nullable List<String> facets) {
        if (facets != null && !facets.isEmpty()) {
            ArrayList predicates = Lists.newArrayList();
            for (String facet : facets) {
                if (!StringUtils.isNotEmpty((String)facet) || facet.startsWith("!")) continue;
                try {
                    final Class<?> facetClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(facet);
                    predicates.add(new Predicate<Repository>(){

                        public boolean apply(@Nullable Repository input) {
                            return input != null && input.getRepositoryKind().isFacetAvailable(facetClass);
                        }
                    });
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.log.warn("Repositories will not be filtered by facet {} as it could not be loaded", (Object)facet);
                }
            }
            if (!predicates.isEmpty()) {
                if (predicates.size() == 1) {
                    return (Predicate)predicates.get(0);
                }
                return Predicates.or((Iterable)predicates);
            }
        }
        return null;
    }

    private Predicate<Repository> hasNoneOfFacets(@Nullable List<String> facets) {
        if (facets != null && !facets.isEmpty()) {
            ArrayList predicates = Lists.newArrayList();
            for (String facet : facets) {
                if (!StringUtils.isNotEmpty((String)facet) || !facet.startsWith("!")) continue;
                String actualFacet = facet.substring(1);
                try {
                    final Class<?> facetClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(actualFacet);
                    predicates.add(new Predicate<Repository>(){

                        public boolean apply(@Nullable Repository input) {
                            return input != null && !input.getRepositoryKind().isFacetAvailable(facetClass);
                        }
                    });
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.log.warn("Repositories will not be filtered by facet {} as it could not be loaded", (Object)actualFacet);
                }
            }
            if (!predicates.isEmpty()) {
                if (predicates.size() == 1) {
                    return (Predicate)predicates.get(0);
                }
                return Predicates.and((Iterable)predicates);
            }
        }
        return null;
    }

    private Predicate<Repository> hasAnyOfContentClasses(List<String> contentClasses) {
        if (contentClasses != null && !contentClasses.isEmpty()) {
            ArrayList predicates = Lists.newArrayList();
            for (final String contentClass : contentClasses) {
                if (!StringUtils.isNotEmpty((String)contentClass) || contentClass.startsWith("!")) continue;
                predicates.add(new Predicate<Repository>(){

                    public boolean apply(@Nullable Repository input) {
                        return input != null && input.getRepositoryContentClass().getId().equals(contentClass);
                    }
                });
            }
            if (!predicates.isEmpty()) {
                if (predicates.size() == 1) {
                    return (Predicate)predicates.get(0);
                }
                return Predicates.or((Iterable)predicates);
            }
        }
        return null;
    }

    private Predicate<Repository> hasNoneOfContentClasses(List<String> contentClasses) {
        if (contentClasses != null && !contentClasses.isEmpty()) {
            ArrayList predicates = Lists.newArrayList();
            for (final String contentClass : contentClasses) {
                if (!StringUtils.isNotEmpty((String)contentClass) || !contentClass.startsWith("!")) continue;
                predicates.add(new Predicate<Repository>(){

                    public boolean apply(@Nullable Repository input) {
                        return input != null && !input.getRepositoryContentClass().getId().equals(contentClass.substring(1));
                    }
                });
            }
            if (!predicates.isEmpty()) {
                return Predicates.or((Iterable)predicates);
            }
        }
        return null;
    }

    private static <T> Iterable<T> removeNulls(T ... values) {
        return StoresResource.removeNulls(Arrays.asList(values));
    }

    private static <T> Iterable<T> removeNulls(Iterable<T> values) {
        return Iterables.filter(values, (Predicate)Predicates.notNull());
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="(All Repositories)")
        public String allRepositoriesName();
    }
}

