/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.rest;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.nexus.capabilities.model.CapabilityTypeXO;
import org.sonatype.nexus.capabilities.model.FormFieldXO;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.Selectable;
import org.sonatype.nexus.plugins.capabilities.CapabilityDescriptor;
import org.sonatype.nexus.plugins.capabilities.CapabilityDescriptorRegistry;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.siesta.common.Resource;

@Named
@Singleton
@Path(value="/capabilities/types")
@Produces(value={"application/xml", "application/json"})
public class CapabilityTypesResource
extends ComponentSupport
implements Resource {
    public static final String RESOURCE_URI = "/capabilities/types";
    public static final String $INCLUDE_NOT_EXPOSED = "$includeNotExposed";
    private final CapabilityDescriptorRegistry capabilityDescriptorRegistry;

    @Inject
    public CapabilityTypesResource(CapabilityDescriptorRegistry capabilityDescriptorRegistry) {
        this.capabilityDescriptorRegistry = capabilityDescriptorRegistry;
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @RequiresPermissions(value={"nexus:capabilityTypes:read"})
    public List<CapabilityTypeXO> get(@QueryParam(value="$includeNotExposed") Boolean includeNotExposed) {
        ArrayList types = Lists.newArrayList();
        CapabilityDescriptor[] descriptors = this.capabilityDescriptorRegistry.getAll();
        if (descriptors != null) {
            CapabilityDescriptor[] capabilityDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                CapabilityDescriptor descriptor = capabilityDescriptorArray[n2];
                if (includeNotExposed != null && includeNotExposed.booleanValue() || descriptor.isExposed()) {
                    CapabilityTypeXO type = new CapabilityTypeXO().withId(descriptor.type().toString()).withName(descriptor.name()).withAbout(descriptor.about());
                    types.add(type);
                    if (descriptor.formFields() != null) {
                        type.withFormFields(Lists.transform(descriptor.formFields(), (Function)new Function<FormField, FormFieldXO>(){

                            @Nullable
                            public FormFieldXO apply(@Nullable FormField input) {
                                if (input == null) {
                                    return null;
                                }
                                FormFieldXO formField = new FormFieldXO().withId(input.getId()).withType(input.getType()).withLabel(input.getLabel()).withHelpText(input.getHelpText()).withRequired(input.isRequired()).withRegexValidation(input.getRegexValidation());
                                if (input.getInitialValue() != null) {
                                    formField.setInitialValue(input.getInitialValue().toString());
                                }
                                if (input instanceof Selectable) {
                                    formField.withStorePath(((Selectable)input).getStorePath()).withStoreRoot(((Selectable)input).getStoreRoot()).withIdMapping(((Selectable)input).getIdMapping()).withNameMapping(((Selectable)input).getNameMapping());
                                }
                                return formField;
                            }
                        }));
                    }
                }
                ++n2;
            }
        }
        return types;
    }
}

