/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.rest;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.capabilities.model.CapabilityStatusXO;
import org.sonatype.nexus.capabilities.model.CapabilityXO;
import org.sonatype.nexus.capabilities.model.PropertyXO;
import org.sonatype.nexus.capabilities.model.TagXO;
import org.sonatype.nexus.plugins.capabilities.Capability;
import org.sonatype.nexus.plugins.capabilities.CapabilityDescriptor;
import org.sonatype.nexus.plugins.capabilities.CapabilityIdentity;
import org.sonatype.nexus.plugins.capabilities.CapabilityNotFoundException;
import org.sonatype.nexus.plugins.capabilities.CapabilityReference;
import org.sonatype.nexus.plugins.capabilities.CapabilityRegistry;
import org.sonatype.nexus.plugins.capabilities.CapabilityType;
import org.sonatype.nexus.plugins.capabilities.Tag;
import org.sonatype.nexus.plugins.capabilities.Taggable;
import org.sonatype.nexus.plugins.capabilities.support.CapabilityReferenceFilterBuilder;
import org.sonatype.sisu.goodies.common.ComponentSupport;
import org.sonatype.sisu.siesta.common.Resource;

@Named
@Singleton
@Path(value="/capabilities")
public class CapabilitiesResource
extends ComponentSupport
implements Resource {
    public static final String RESOURCE_URI = "/capabilities";
    private static final String $TYPE = "$type";
    private static final String $PROPERTY = "$p";
    private static final String $ENABLED = "$enabled";
    private static final String $ACTIVE = "$active";
    private static final String $INCLUDE_NOT_EXPOSED = "$includeNotExposed";
    private static final Logger log = LoggerFactory.getLogger(CapabilitiesResource.class);
    private final CapabilityRegistry capabilityRegistry;

    @Inject
    public CapabilitiesResource(CapabilityRegistry capabilityRegistry) {
        this.capabilityRegistry = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry);
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/xml", "application/json"})
    @RequiresPermissions(value={"nexus:capabilities:read"})
    public CapabilityXO get(@PathParam(value="id") String id) {
        CapabilityIdentity capabilityId = CapabilityIdentity.capabilityIdentity(id);
        CapabilityReference reference = this.capabilityRegistry.get(capabilityId);
        if (reference == null) {
            throw new CapabilityNotFoundException(capabilityId);
        }
        return CapabilitiesResource.asCapability(reference);
    }

    @GET
    @Path(value="/{id}/status")
    @Produces(value={"application/xml", "application/json"})
    @RequiresPermissions(value={"nexus:capabilities:read"})
    public CapabilityStatusXO getInfo(@PathParam(value="id") String id) {
        CapabilityIdentity capabilityId = CapabilityIdentity.capabilityIdentity(id);
        CapabilityReference reference = this.capabilityRegistry.get(capabilityId);
        if (reference == null) {
            throw new CapabilityNotFoundException(capabilityId);
        }
        return CapabilitiesResource.asCapabilityStatus(reference);
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @RequiresPermissions(value={"nexus:capabilities:read"})
    public List<CapabilityStatusXO> get(@QueryParam(value="$type") String type, @QueryParam(value="$enabled") Boolean enabled, @QueryParam(value="$active") Boolean active, @QueryParam(value="$includeNotExposed") Boolean includeNotExposed, @QueryParam(value="$p") List<String> properties) {
        Collection<? extends CapabilityReference> references = this.capabilityRegistry.get(this.buildFilter(type, enabled, active, includeNotExposed, properties));
        return Lists.transform((List)Lists.newArrayList(references), (Function)new Function<CapabilityReference, CapabilityStatusXO>(){

            @Nullable
            public CapabilityStatusXO apply(@Nullable CapabilityReference input) {
                if (input == null) {
                    return null;
                }
                return CapabilitiesResource.asCapabilityStatus(input);
            }
        });
    }

    @POST
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    @RequiresPermissions(value={"nexus:capabilities:create"})
    public CapabilityStatusXO post(CapabilityXO capability) throws Exception {
        return CapabilitiesResource.asCapabilityStatus(this.capabilityRegistry.add(CapabilityType.capabilityType(capability.getTypeId()), capability.isEnabled(), capability.getNotes(), CapabilitiesResource.asMap(capability.getProperties())));
    }

    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/xml", "application/json"})
    @RequiresPermissions(value={"nexus:capabilities:update"})
    public CapabilityStatusXO put(@PathParam(value="id") String id, CapabilityXO capability) throws Exception {
        return CapabilitiesResource.asCapabilityStatus(this.capabilityRegistry.update(CapabilityIdentity.capabilityIdentity(id), capability.isEnabled(), capability.getNotes(), CapabilitiesResource.asMap(capability.getProperties())));
    }

    @DELETE
    @Path(value="/{id}")
    @RequiresPermissions(value={"nexus:capabilities:delete"})
    public void delete(@PathParam(value="id") String id) throws Exception {
        this.capabilityRegistry.remove(CapabilityIdentity.capabilityIdentity(id));
    }

    @PUT
    @Path(value="/{id}/enable")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/xml", "application/json"})
    @RequiresPermissions(value={"nexus:capabilities:update"})
    public CapabilityStatusXO enable(@PathParam(value="id") String id) throws Exception {
        return CapabilitiesResource.asCapabilityStatus(this.capabilityRegistry.enable(CapabilityIdentity.capabilityIdentity(id)));
    }

    @PUT
    @Path(value="/{id}/disable")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/xml", "application/json"})
    @RequiresPermissions(value={"nexus:capabilities:update"})
    public CapabilityStatusXO disable(@PathParam(value="id") String id) throws Exception {
        return CapabilitiesResource.asCapabilityStatus(this.capabilityRegistry.disable(CapabilityIdentity.capabilityIdentity(id)));
    }

    static Map<String, String> asMap(List<PropertyXO> properties) {
        HashMap map = Maps.newHashMap();
        if (properties != null) {
            for (PropertyXO property : properties) {
                map.put(property.getKey(), property.getValue());
            }
        }
        return map;
    }

    static CapabilityStatusXO asCapabilityStatus(CapabilityReference reference) {
        List tagXOs;
        Set<Tag> tagSet;
        Preconditions.checkNotNull((Object)reference);
        CapabilityDescriptor descriptor = reference.context().descriptor();
        Capability capability = reference.capability();
        CapabilityStatusXO capabilityStatus = new CapabilityStatusXO().withCapability(CapabilitiesResource.asCapability(reference)).withTypeName(descriptor.name()).withActive(reference.context().isActive()).withError(reference.context().hasFailure());
        try {
            capabilityStatus.setDescription(capability.description());
        }
        catch (Throwable e) {
            log.warn("Failed to render description of capability '{}/{}' due to {}/{}", new Object[]{reference.context().type(), reference.context().id(), e.getClass().getName(), e.getMessage(), log.isDebugEnabled() ? e : null});
            capabilityStatus.setDescription(null);
        }
        try {
            capabilityStatus.setStatus(capability.status());
        }
        catch (Throwable e) {
            log.warn("Failed to render status of capability '{}/{}' due to {}/{}", new Object[]{reference.context().type(), reference.context().id(), e.getClass().getName(), e.getMessage(), log.isDebugEnabled() ? e : null});
            capabilityStatus.setStatus(null);
        }
        capabilityStatus.setStateDescription(reference.context().stateDescription());
        HashSet tags = Sets.newHashSet();
        try {
            if (descriptor instanceof Taggable && (tagSet = ((Taggable)((Object)descriptor)).getTags()) != null) {
                tags.addAll(tagSet);
            }
        }
        catch (Throwable e) {
            log.warn("Failed to retrieve tags from capability descriptor '{}' due to {}/{}", new Object[]{reference.context().type(), e.getClass().getName(), e.getMessage(), log.isDebugEnabled() ? e : null});
        }
        try {
            if (capability instanceof Taggable && (tagSet = ((Taggable)((Object)capability)).getTags()) != null) {
                tags.addAll(tagSet);
            }
        }
        catch (Throwable e) {
            log.warn("Failed to retrieve tags from capability '{}/{}' due to {}/{}", new Object[]{reference.context().type(), reference.context().id(), e.getClass().getName(), e.getMessage(), log.isDebugEnabled() ? e : null});
        }
        if (!(tagXOs = Lists.transform((List)Lists.newArrayList((Iterable)Collections2.filter((Collection)tags, (Predicate)Predicates.notNull())), (Function)new Function<Tag, TagXO>(){

            public TagXO apply(Tag input) {
                return new TagXO().withKey(input.key()).withValue(input.value());
            }
        })).isEmpty()) {
            capabilityStatus.setTags(tagXOs);
        }
        return capabilityStatus;
    }

    private static CapabilityXO asCapability(CapabilityReference reference) {
        CapabilityXO capability = new CapabilityXO().withId(reference.context().id().toString()).withNotes(reference.context().notes()).withEnabled(reference.context().isEnabled()).withTypeId(reference.context().type().toString());
        if (reference.context().properties() != null) {
            for (Map.Entry<String, String> entry : reference.context().properties().entrySet()) {
                capability.getProperties().add(new PropertyXO().withKey(entry.getKey()).withValue(entry.getValue()));
            }
        }
        return capability;
    }

    private CapabilityReferenceFilterBuilder.CapabilityReferenceFilter buildFilter(String type, Boolean enabled, Boolean active, Boolean includeNotExposed, List<String> properties) {
        CapabilityReferenceFilterBuilder.CapabilityReferenceFilter filter = CapabilityReferenceFilterBuilder.capabilities();
        if (type != null) {
            filter = filter.withType(CapabilityType.capabilityType(type));
        }
        if (enabled != null) {
            filter = filter.enabled(enabled);
        }
        if (active != null) {
            filter = filter.active(active);
        }
        if (includeNotExposed != null && includeNotExposed.booleanValue()) {
            filter = filter.includeNotExposed();
        }
        if (properties != null) {
            Iterator<String> iterator = properties.iterator();
            while (iterator.hasNext()) {
                String property;
                String propertyName = property = iterator.next();
                String propertyValue = "*";
                if (property.contains(":") && (propertyName = property.substring(0, propertyName.indexOf(58))).length() < property.length() - 1) {
                    propertyValue = property.substring(propertyName.length() + 1);
                }
                filter = "*".equals(propertyValue) ? filter.withBoundedProperty(propertyName) : filter.withProperty(propertyName, propertyValue);
            }
        }
        return filter;
    }
}

