/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.guice;

import com.google.common.base.Preconditions;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.name.Names;
import io.kazuki.v0.store.easy.EasyKeyValueStoreModule;
import io.kazuki.v0.store.jdbi.JdbiDataSourceConfiguration;
import io.kazuki.v0.store.keyvalue.KeyValueStoreConfiguration;
import io.kazuki.v0.store.lifecycle.LifecycleModule;
import io.kazuki.v0.store.sequence.SequenceServiceConfiguration;
import java.io.File;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.configuration.application.ApplicationDirectories;
import org.sonatype.nexus.plugins.capabilities.internal.ActivationConditionHandlerFactory;
import org.sonatype.nexus.plugins.capabilities.internal.ValidityConditionHandlerFactory;
import org.sonatype.nexus.plugins.capabilities.internal.storage.CapabilityStorage;
import org.sonatype.nexus.plugins.capabilities.internal.storage.XmlCapabilityStorage;
import org.sonatype.nexus.plugins.capabilities.internal.validator.ValidatorFactory;

@Named
public class GuiceModule
extends AbstractModule {
    protected void configure() {
        this.bind(CapabilityStorage.class).to(XmlCapabilityStorage.class);
        this.install(new FactoryModuleBuilder().build(ActivationConditionHandlerFactory.class));
        this.install(new FactoryModuleBuilder().build(ValidityConditionHandlerFactory.class));
        this.install(new FactoryModuleBuilder().build(ValidatorFactory.class));
        this.install((Module)new LifecycleModule("nexuscapability", new String[0]));
        this.bind(JdbiDataSourceConfiguration.class).annotatedWith((Annotation)Names.named((String)"nexuscapability")).toProvider(JdbiConfigurationProvider.class).in(Scopes.SINGLETON);
        this.install((Module)new EasyKeyValueStoreModule("nexuscapability", null).withSequenceConfig(this.getSequenceServiceConfiguration()).withKeyValueStoreConfig(this.getKeyValueStoreConfiguration()));
    }

    private SequenceServiceConfiguration getSequenceServiceConfiguration() {
        SequenceServiceConfiguration.Builder builder = new SequenceServiceConfiguration.Builder();
        builder.withDbType("h2");
        builder.withGroupName("nexus");
        builder.withStoreName("capability");
        builder.withStrictTypeCreation(true);
        return builder.build();
    }

    private KeyValueStoreConfiguration getKeyValueStoreConfiguration() {
        KeyValueStoreConfiguration.Builder builder = new KeyValueStoreConfiguration.Builder();
        builder.withDbType("h2");
        builder.withGroupName("nexus");
        builder.withStoreName("capability");
        builder.withPartitionName("default");
        builder.withPartitionSize(Long.valueOf(100000L));
        builder.withStrictTypeCreation(true);
        builder.withDataType("capability");
        return builder.build();
    }

    private static class JdbiConfigurationProvider
    implements Provider<JdbiDataSourceConfiguration> {
        private final ApplicationDirectories directories;

        @Inject
        public JdbiConfigurationProvider(ApplicationDirectories directories) {
            this.directories = (ApplicationDirectories)Preconditions.checkNotNull((Object)directories);
        }

        public JdbiDataSourceConfiguration get() {
            JdbiDataSourceConfiguration.Builder builder = new JdbiDataSourceConfiguration.Builder();
            builder.withJdbcDriver("org.h2.Driver");
            File dir = this.directories.getWorkDirectory("db/capabilities", false);
            File file = new File(dir, dir.getName());
            builder.withJdbcUrl("jdbc:h2:" + file.getAbsolutePath());
            builder.withJdbcUser("root");
            builder.withJdbcPassword("not_really_used");
            builder.withPoolMinConnections(25);
            builder.withPoolMaxConnections(25);
            return builder.build();
        }
    }
}

