/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.config.persistence.io.xpp3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;
import org.sonatype.nexus.plugins.capabilities.internal.config.persistence.CCapability;
import org.sonatype.nexus.plugins.capabilities.internal.config.persistence.CCapabilityProperty;
import org.sonatype.nexus.plugins.capabilities.internal.config.persistence.Configuration;

public class NexusCapabilitiesConfigurationXpp3Writer {
    private static final String NAMESPACE = null;

    public void write(Writer writer, Configuration configuration) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(configuration.getModelEncoding(), null);
        this.writeConfiguration(configuration, "capabilitiesConfiguration", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    public void write(OutputStream stream, Configuration configuration) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(stream, configuration.getModelEncoding());
        serializer.startDocument(configuration.getModelEncoding(), null);
        this.writeConfiguration(configuration, "capabilitiesConfiguration", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeCCapability(CCapability cCapability, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cCapability.getVersion() != 0) {
            serializer.startTag(NAMESPACE, "version").text(String.valueOf(cCapability.getVersion())).endTag(NAMESPACE, "version");
        }
        if (cCapability.getId() != null) {
            serializer.startTag(NAMESPACE, "id").text(cCapability.getId()).endTag(NAMESPACE, "id");
        }
        if (cCapability.getNotes() != null) {
            serializer.startTag(NAMESPACE, "notes").text(cCapability.getNotes()).endTag(NAMESPACE, "notes");
        }
        if (!cCapability.isEnabled()) {
            serializer.startTag(NAMESPACE, "enabled").text(String.valueOf(cCapability.isEnabled())).endTag(NAMESPACE, "enabled");
        }
        if (cCapability.getTypeId() != null) {
            serializer.startTag(NAMESPACE, "typeId").text(cCapability.getTypeId()).endTag(NAMESPACE, "typeId");
        }
        if (cCapability.getProperties() != null && cCapability.getProperties().size() > 0) {
            serializer.startTag(NAMESPACE, "properties");
            for (CCapabilityProperty o : cCapability.getProperties()) {
                this.writeCCapabilityProperty(o, "property", serializer);
            }
            serializer.endTag(NAMESPACE, "properties");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeCCapabilityProperty(CCapabilityProperty cCapabilityProperty, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (cCapabilityProperty.getKey() != null) {
            serializer.startTag(NAMESPACE, "key").text(cCapabilityProperty.getKey()).endTag(NAMESPACE, "key");
        }
        if (cCapabilityProperty.getValue() != null) {
            serializer.startTag(NAMESPACE, "value").text(cCapabilityProperty.getValue()).endTag(NAMESPACE, "value");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeConfiguration(Configuration configuration, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (configuration.getVersion() != null) {
            serializer.startTag(NAMESPACE, "version").text(configuration.getVersion()).endTag(NAMESPACE, "version");
        }
        if (configuration.getCapabilities() != null && configuration.getCapabilities().size() > 0) {
            serializer.startTag(NAMESPACE, "capabilities");
            for (CCapability o : configuration.getCapabilities()) {
                this.writeCCapability(o, "capability", serializer);
            }
            serializer.endTag(NAMESPACE, "capabilities");
        }
        serializer.endTag(NAMESPACE, tagName);
    }
}

