/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.config.persistence;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.sonatype.nexus.plugins.capabilities.internal.config.persistence.CCapabilityProperty;

public class CCapability
implements Serializable,
Cloneable {
    private int version = 0;
    private String id;
    private String notes;
    private boolean enabled = true;
    private String typeId;
    private List<CCapabilityProperty> properties;

    public void addProperty(CCapabilityProperty cCapabilityProperty) {
        this.getProperties().add(cCapabilityProperty);
    }

    public CCapability clone() {
        try {
            CCapability copy = (CCapability)super.clone();
            if (this.properties != null) {
                copy.properties = new ArrayList<CCapabilityProperty>();
                for (CCapabilityProperty item : this.properties) {
                    copy.properties.add(item.clone());
                }
            }
            return copy;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + " does not support clone()").initCause(ex);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getNotes() {
        return this.notes;
    }

    public List<CCapabilityProperty> getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<CCapabilityProperty>();
        }
        return this.properties;
    }

    public String getTypeId() {
        return this.typeId;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void removeProperty(CCapabilityProperty cCapabilityProperty) {
        this.getProperties().remove(cCapabilityProperty);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public void setProperties(List<CCapabilityProperty> properties) {
        this.properties = properties;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public void setVersion(int version) {
        this.version = version;
    }
}

