/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.plugins.capabilities.internal.condition;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import org.sonatype.nexus.plugins.capabilities.internal.condition.RepositoryConditionSupport;
import org.sonatype.nexus.plugins.capabilities.support.condition.RepositoryConditions;
import org.sonatype.nexus.proxy.events.RepositoryEventProxyModeChanged;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventAdd;
import org.sonatype.nexus.proxy.events.RepositoryRegistryEventRemove;
import org.sonatype.nexus.proxy.registry.RepositoryRegistry;
import org.sonatype.nexus.proxy.repository.ProxyMode;
import org.sonatype.nexus.proxy.repository.ProxyRepository;
import org.sonatype.sisu.goodies.eventbus.EventBus;

public class RepositoryProxyModeCondition
extends RepositoryConditionSupport {
    private final ProxyMode proxyMode;

    public RepositoryProxyModeCondition(EventBus eventBus, RepositoryRegistry repositoryRegistry, ProxyMode proxyMode, RepositoryConditions.RepositoryId repositoryId) {
        super(eventBus, repositoryRegistry, repositoryId);
        this.proxyMode = (ProxyMode)Preconditions.checkNotNull((Object)proxyMode);
    }

    @Override
    @AllowConcurrentEvents
    @Subscribe
    public void handle(RepositoryRegistryEventAdd event) {
        if (this.sameRepositoryAs(event.getRepository().getId()) && event.getRepository().getRepositoryKind().isFacetAvailable(ProxyRepository.class)) {
            this.setSatisfied(this.proxyMode.equals((Object)((ProxyRepository)event.getRepository().adaptToFacet(ProxyRepository.class)).getProxyMode()));
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(RepositoryEventProxyModeChanged event) {
        if (this.sameRepositoryAs(event.getRepository().getId())) {
            this.setSatisfied(this.proxyMode.equals((Object)event.getNewProxyMode()));
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(RepositoryRegistryEventRemove event) {
        if (this.sameRepositoryAs(event.getRepository().getId())) {
            this.setSatisfied(false);
        }
    }

    public String toString() {
        try {
            String id = this.getRepositoryId();
            return String.format("Repository '%s' is %s", id, this.proxyMode.toString());
        }
        catch (Exception exception) {
            return String.format("Repository '(could not be evaluated)' is %s", this.proxyMode.toString());
        }
    }

    @Override
    public String explainSatisfied() {
        String mode = "not blocked";
        if (this.proxyMode.equals((Object)ProxyMode.BLOCKED_MANUAL)) {
            mode = "manually blocked";
        } else if (this.proxyMode.equals((Object)ProxyMode.BLOCKED_AUTO)) {
            mode = "auto blocked";
        }
        try {
            String id = this.getRepositoryId();
            return String.format("Repository '%s' is %s", id, mode);
        }
        catch (Exception exception) {
            return String.format("Repository '(could not be evaluated)' is %s", mode);
        }
    }

    @Override
    public String explainUnsatisfied() {
        String mode = "blocked";
        if (this.proxyMode.equals((Object)ProxyMode.BLOCKED_MANUAL)) {
            mode = "not manually blocked";
        } else if (this.proxyMode.equals((Object)ProxyMode.BLOCKED_AUTO)) {
            mode = "not auto blocked";
        }
        try {
            String id = this.getRepositoryId();
            return String.format("Repository '%s' is %s", id, mode);
        }
        catch (Exception exception) {
            return String.format("Repository '(could not be evaluated)' is %s", mode);
        }
    }
}

